/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class SelectPlayViewCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public SelectPlayViewCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (Views.isSessionView(viewManager.getActiveViewId())) {
            ITrack selectedTrack = this.model.getSelectedTrack();
            if (selectedTrack == null) {
                ((PushControlSurface)this.surface).getDisplay().notify("Please select a track first.");
                return;
            }
            Integer preferredView = viewManager.getPreferredView(selectedTrack.getPosition());
            viewManager.setActiveView(preferredView == null ? Views.VIEW_PLAY : preferredView);
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_VIEW_SELECT)) {
            modeManager.restoreMode();
        } else {
            modeManager.setActiveMode(Modes.MODE_VIEW_SELECT);
        }
    }
}

