/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.device.DeviceBrowserMode;
import de.mossgrabers.controller.push.mode.device.DeviceParamsMode;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;

public class PushCursorCommand
extends CursorCommand<PushControlSurface, PushConfiguration> {
    public PushCursorCommand(CursorCommand.Direction direction, IModel model, PushControlSurface surface) {
        super(direction, model, surface);
    }

    @Override
    protected void updateArrowStates() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        this.canScrollUp = tb.canScrollScenesUp();
        this.canScrollDown = tb.canScrollScenesDown();
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_DEVICE_PARAMS)) {
            DeviceParamsMode mode = (DeviceParamsMode)modeManager.getActiveMode();
            this.canScrollLeft = mode.canSelectPreviousPage();
            this.canScrollRight = mode.canSelectNextPage();
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            IBrowser browser = this.model.getBrowser();
            this.canScrollLeft = browser.hasPreviousContentType();
            this.canScrollRight = browser.hasNextContentType();
            return;
        }
        if (Modes.isLayerMode(modeManager.getActiveModeId())) {
            ICursorDevice cd = this.model.getCursorDevice();
            this.canScrollLeft = cd.canScrollLayersOrDrumPadsUp();
            this.canScrollRight = cd.canScrollLayersOrDrumPadsDown();
            return;
        }
        ITrack sel = tb.getSelectedTrack();
        int selIndex = sel != null ? sel.getIndex() : -1;
        this.canScrollLeft = selIndex > 0 || tb.canScrollTracksUp();
        this.canScrollRight = selIndex >= 0 && selIndex < 7 && tb.getTrack(selIndex + 1).doesExist() || tb.canScrollTracksDown();
    }

    @Override
    protected void scrollLeft() {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_DEVICE_PARAMS)) {
            DeviceParamsMode paramsMode = (DeviceParamsMode)modeManager.getActiveMode();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                paramsMode.selectPreviousPageBank();
            } else {
                paramsMode.selectPreviousPage();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            ((DeviceBrowserMode)modeManager.getActiveMode()).resetFilterColumn();
            this.model.getBrowser().previousContentType();
            return;
        }
        if (Modes.isLayerMode(modeManager.getActiveModeId())) {
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                this.model.getCursorDevice().previousLayerOrDrumPadBank();
            } else {
                this.model.getCursorDevice().previousLayerOrDrumPad();
            }
            return;
        }
        this.scrollTracksLeft();
    }

    @Override
    protected void scrollRight() {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_DEVICE_PARAMS)) {
            DeviceParamsMode activeMode = (DeviceParamsMode)modeManager.getActiveMode();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                activeMode.selectNextPageBank();
            } else {
                activeMode.selectNextPage();
            }
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            ((DeviceBrowserMode)modeManager.getActiveMode()).resetFilterColumn();
            this.model.getBrowser().nextContentType();
            return;
        }
        if (Modes.isLayerMode(modeManager.getActiveModeId())) {
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                this.model.getCursorDevice().nextLayerOrDrumPadBank();
            } else {
                this.model.getCursorDevice().nextLayerOrDrumPad();
            }
            return;
        }
        this.scrollTracksRight();
    }
}

