/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PanSendCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public PanSendCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        Integer mode;
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Integer currentMode = modeManager.getActiveModeId();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPush2() && ((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
            Integer mode2;
            if (this.model.isEffectTrackBankActive()) {
                mode2 = Modes.MODE_DEVICE_LAYER_PAN;
            } else {
                mode2 = currentMode + 1;
                if (mode2 < Modes.MODE_DEVICE_LAYER_PAN || mode2 > Modes.MODE_DEVICE_LAYER_SEND8) {
                    mode2 = Modes.MODE_DEVICE_LAYER_PAN;
                }
                ITrackBank tb = this.model.getTrackBank();
                if (mode2 < Modes.MODE_DEVICE_LAYER_SEND1 || mode2 > Modes.MODE_DEVICE_LAYER_SEND8 || tb.canEditSend(mode2 - Modes.MODE_DEVICE_LAYER_SEND1)) {
                    mode2 = Modes.MODE_DEVICE_LAYER_PAN;
                }
            }
            modeManager.setActiveMode(mode2);
            return;
        }
        if (this.model.isEffectTrackBankActive()) {
            mode = Modes.MODE_PAN;
        } else {
            mode = currentMode + 1;
            if (mode < Modes.MODE_PAN || mode > Modes.MODE_SEND8) {
                mode = Modes.MODE_PAN;
            }
            ITrackBank tb = this.model.getTrackBank();
            if (mode < Modes.MODE_SEND1 || mode > Modes.MODE_SEND8 || !tb.canEditSend(mode - Modes.MODE_SEND1)) {
                mode = Modes.MODE_PAN;
            }
        }
        modeManager.setActiveMode(mode);
    }
}

