/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MuteCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public MuteCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        ((PushControlSurface)this.surface).getViewManager().getActiveView().updateNoteMapping();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPush2()) {
            config.setTrackState(PushConfiguration.TrackState.MUTE);
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            if (event == ButtonEvent.UP) {
                config.setMuteSoloLocked(!config.isMuteSoloLocked());
            }
            return;
        }
        if (config.isMuteSoloLocked()) {
            config.setTrackState(PushConfiguration.TrackState.MUTE);
            return;
        }
        if (event == ButtonEvent.DOWN) {
            config.setIsMuteLongPressed(false);
            return;
        }
        if (event == ButtonEvent.LONG) {
            config.setIsMuteLongPressed(true);
            config.setTrackState(PushConfiguration.TrackState.MUTE);
            return;
        }
        if (config.isMuteLongPressed()) {
            config.setIsMuteLongPressed(false);
            return;
        }
        Integer activeModeId = ((PushControlSurface)this.surface).getModeManager().getActiveModeId();
        if (Modes.isTrackMode(activeModeId)) {
            ITrack selTrack = this.model.getSelectedTrack();
            if (selTrack != null) {
                selTrack.toggleMute();
            }
        } else if (Modes.isLayerMode(activeModeId)) {
            ICursorDevice cd = this.model.getCursorDevice();
            IChannel layer = cd.getSelectedLayerOrDrumPad();
            if (layer != null) {
                cd.toggleLayerOrDrumPadMute(layer.getIndex());
            }
        } else if (activeModeId == Modes.MODE_MASTER) {
            this.model.getMasterTrack().toggleMute();
        }
    }
}

