/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MastertrackCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean quitMasterMode = false;
    private int selectedTrackBeforeMasterMode = -1;

    public MastertrackCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            return;
        }
        switch (event) {
            case DOWN: {
                this.quitMasterMode = false;
                break;
            }
            case UP: {
                this.handleButtonUp(modeManager);
                break;
            }
            case LONG: {
                this.quitMasterMode = true;
                modeManager.setActiveMode(Modes.MODE_FRAME);
            }
        }
    }

    private void handleButtonUp(ModeManager modeManager) {
        if (this.quitMasterMode) {
            modeManager.restoreMode();
            return;
        }
        if (modeManager.getActiveModeId() == Modes.MODE_MASTER) {
            if (this.selectedTrackBeforeMasterMode >= 0) {
                this.model.getCurrentTrackBank().getTrack(this.selectedTrackBeforeMasterMode).select();
            }
            return;
        }
        modeManager.setActiveMode(Modes.MODE_MASTER);
        this.model.getMasterTrack().select();
        ITrack track = this.model.getSelectedTrack();
        this.selectedTrackBeforeMasterMode = track == null ? -1 : track.getIndex();
    }
}

