/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ViewManager;

public class LayoutCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public LayoutCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.setActiveView(Views.VIEW_PIANO);
        } else if (viewManager.isActiveView(Views.VIEW_PIANO)) {
            viewManager.setActiveView(this.model.getHost().hasClips() ? Views.VIEW_DRUM64 : Views.VIEW_PLAY);
        } else if (viewManager.isActiveView(Views.VIEW_DRUM64)) {
            viewManager.setActiveView(Views.VIEW_PLAY);
        } else if (viewManager.isActiveView(Views.VIEW_SEQUENCER)) {
            viewManager.setActiveView(Views.VIEW_RAINDROPS);
        } else if (viewManager.isActiveView(Views.VIEW_RAINDROPS)) {
            viewManager.setActiveView(Views.VIEW_DRUM);
        } else if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.setActiveView(Views.VIEW_DRUM4);
        } else if (viewManager.isActiveView(Views.VIEW_DRUM4)) {
            viewManager.setActiveView(Views.VIEW_DRUM8);
        } else if (viewManager.isActiveView(Views.VIEW_DRUM8)) {
            viewManager.setActiveView(Views.VIEW_SEQUENCER);
        } else {
            PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            if (viewManager.isActiveView(Views.VIEW_SESSION)) {
                if (configuration.isFlipSession()) {
                    viewManager.setActiveView(Views.VIEW_SCENE_PLAY);
                } else {
                    configuration.setFlipSession(true);
                }
            } else if (viewManager.isActiveView(Views.VIEW_SCENE_PLAY)) {
                configuration.setFlipSession(false);
                viewManager.setActiveView(Views.VIEW_SESSION);
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (Views.isSequencerView(viewManager.getActiveViewId())) {
            viewManager.setActiveView(Views.VIEW_PLAY);
        } else if (viewManager.getView(Views.VIEW_SEQUENCER) != null) {
            viewManager.setActiveView(Views.VIEW_SEQUENCER);
        }
    }
}

