/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AutomationCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean quitAutomationMode;

    public AutomationCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setButtonConsumed(((PushControlSurface)this.surface).getDeleteButtonId());
            if (event == ButtonEvent.DOWN) {
                this.model.getTransport().resetAutomationOverrides();
            }
            return;
        }
        switch (event) {
            case DOWN: {
                this.quitAutomationMode = false;
                break;
            }
            case LONG: {
                this.quitAutomationMode = true;
                ((PushControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_AUTOMATION);
                break;
            }
            case UP: {
                if (this.quitAutomationMode) {
                    ((PushControlSurface)this.surface).getModeManager().restoreMode();
                    break;
                }
                this.doCommand();
            }
        }
    }

    private void doCommand() {
        boolean isShift = ((PushControlSurface)this.surface).isShiftPressed();
        boolean flipRecord = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipRecord();
        if (isShift && !flipRecord || !isShift && flipRecord) {
            this.model.getTransport().toggleWriteClipLauncherAutomation();
        } else {
            ITrack selectedTrack = this.model.getSelectedTrack();
            if (selectedTrack != null) {
                this.model.getTransport().toggleWriteArrangerAutomation();
            }
        }
    }
}

