/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.trigger;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AddTrackCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public AddTrackCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IChannelBank tb = this.model.getTrackBank();
        IApplication application = this.model.getApplication();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            application.addEffectTrack();
            tb = this.model.getEffectTrackBank();
        } else if (((PushControlSurface)this.surface).isSelectPressed()) {
            application.addAudioTrack();
        } else {
            application.addInstrumentTrack();
        }
        IChannelBank bank = tb;
        ((PushControlSurface)this.surface).scheduleTask(() -> {
            int pos = bank.getTrackCount() - 1;
            bank.scrollToChannel(pos);
            bank.getTrack(pos % bank.getNumTracks()).select();
        }, 200L);
    }
}

