/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.pitchbend;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractPitchbendCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class PitchbendCommand
extends AbstractPitchbendCommand<PushControlSurface, PushConfiguration> {
    private int pitchValue = 0;

    public PitchbendCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void onPitchbend(int channel, int data1, int data2) {
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (config.getRibbonMode()) {
            case 0: {
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                break;
            }
            case 1: {
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), data2);
                this.pitchValue = data2;
                break;
            }
            case 2: {
                if (data2 > 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                    break;
                }
                if (data2 < 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 127 - data2 * 2);
                    break;
                }
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 0);
                break;
            }
            case 3: {
                if (data2 > 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), (data2 - 64) * 2);
                    break;
                }
                if (data2 < 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                    break;
                }
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 0);
                break;
            }
            case 4: {
                ITrack selTrack = this.model.getSelectedTrack();
                if (selTrack != null) {
                    selTrack.setVolume(this.model.getValueChanger().toDAWValue(data2));
                }
                return;
            }
        }
        ((PushControlSurface)this.surface).getOutput().sendPitchbend(data1, data2);
    }

    @Override
    public void updateValue() {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (config.getRibbonMode()) {
            case 1: {
                ((PushControlSurface)this.surface).setRibbonValue(this.pitchValue);
                break;
            }
            case 4: {
                ITrack t = this.model.getSelectedTrack();
                ((PushControlSurface)this.surface).setRibbonValue(t == null ? 0 : this.model.getValueChanger().toMidiValue(t.getVolume()));
                break;
            }
            default: {
                ((PushControlSurface)this.surface).setRibbonValue(64);
            }
        }
    }
}

