/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.continuous;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.BaseMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Mode;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SmallKnobTouchCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public SmallKnobTouchCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        boolean isTouched = event == ButtonEvent.DOWN;
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            return;
        }
        Mode activeMode = modeManager.getActiveMode();
        if (activeMode instanceof BaseMode && ((BaseMode)activeMode).isAKnobTouched()) {
            return;
        }
        this.model.getTransport().setTempoIndication(isTouched);
        if (isTouched) {
            modeManager.setActiveMode(Modes.MODE_TRANSPORT);
        } else {
            modeManager.restoreMode();
        }
    }
}

