/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push.command.continuous;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MastertrackTouchCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public MastertrackTouchCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event) {
        boolean isTouched = event == ButtonEvent.DOWN;
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
            return;
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        masterTrack.touchVolume(isTouched);
        if (((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setButtonConsumed(118);
            masterTrack.resetVolume();
            return;
        }
        boolean isMasterMode = modeManager.isActiveMode(Modes.MODE_MASTER);
        if (isTouched && isMasterMode) {
            return;
        }
        if (isTouched) {
            modeManager.setActiveMode(Modes.MODE_MASTER_TEMP);
        } else if (!isMasterMode) {
            modeManager.restoreMode();
        }
    }
}

