/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push;

import de.mossgrabers.controller.push.PushConfiguration;
import de.mossgrabers.controller.push.command.continuous.ConfigurePitchbendCommand;
import de.mossgrabers.controller.push.command.continuous.MastertrackTouchCommand;
import de.mossgrabers.controller.push.command.continuous.SmallKnobTouchCommand;
import de.mossgrabers.controller.push.command.pitchbend.PitchbendCommand;
import de.mossgrabers.controller.push.command.pitchbend.PitchbendSessionCommand;
import de.mossgrabers.controller.push.command.trigger.AccentCommand;
import de.mossgrabers.controller.push.command.trigger.AddEffectCommand;
import de.mossgrabers.controller.push.command.trigger.AddTrackCommand;
import de.mossgrabers.controller.push.command.trigger.AutomationCommand;
import de.mossgrabers.controller.push.command.trigger.ClipCommand;
import de.mossgrabers.controller.push.command.trigger.DeviceCommand;
import de.mossgrabers.controller.push.command.trigger.FixedLengthCommand;
import de.mossgrabers.controller.push.command.trigger.LayoutCommand;
import de.mossgrabers.controller.push.command.trigger.MastertrackCommand;
import de.mossgrabers.controller.push.command.trigger.MuteCommand;
import de.mossgrabers.controller.push.command.trigger.OctaveCommand;
import de.mossgrabers.controller.push.command.trigger.PageLeftCommand;
import de.mossgrabers.controller.push.command.trigger.PageRightCommand;
import de.mossgrabers.controller.push.command.trigger.PanSendCommand;
import de.mossgrabers.controller.push.command.trigger.PushCursorCommand;
import de.mossgrabers.controller.push.command.trigger.PushQuantizeCommand;
import de.mossgrabers.controller.push.command.trigger.RasteredKnobCommand;
import de.mossgrabers.controller.push.command.trigger.ScalesCommand;
import de.mossgrabers.controller.push.command.trigger.SelectCommand;
import de.mossgrabers.controller.push.command.trigger.SelectPlayViewCommand;
import de.mossgrabers.controller.push.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.push.command.trigger.SetupCommand;
import de.mossgrabers.controller.push.command.trigger.ShiftCommand;
import de.mossgrabers.controller.push.command.trigger.SoloCommand;
import de.mossgrabers.controller.push.command.trigger.TrackCommand;
import de.mossgrabers.controller.push.command.trigger.VolumeCommand;
import de.mossgrabers.controller.push.controller.PushColors;
import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.controller.PushDisplay;
import de.mossgrabers.controller.push.mode.AccentMode;
import de.mossgrabers.controller.push.mode.AutomationMode;
import de.mossgrabers.controller.push.mode.ConfigurationMode;
import de.mossgrabers.controller.push.mode.FixedMode;
import de.mossgrabers.controller.push.mode.FrameMode;
import de.mossgrabers.controller.push.mode.GrooveMode;
import de.mossgrabers.controller.push.mode.InfoMode;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.mode.NoteMode;
import de.mossgrabers.controller.push.mode.NoteViewSelectMode;
import de.mossgrabers.controller.push.mode.RibbonMode;
import de.mossgrabers.controller.push.mode.ScaleLayoutMode;
import de.mossgrabers.controller.push.mode.ScalesMode;
import de.mossgrabers.controller.push.mode.SessionMode;
import de.mossgrabers.controller.push.mode.SessionViewSelectMode;
import de.mossgrabers.controller.push.mode.SetupMode;
import de.mossgrabers.controller.push.mode.TransportMode;
import de.mossgrabers.controller.push.mode.device.DeviceBrowserMode;
import de.mossgrabers.controller.push.mode.device.DeviceLayerMode;
import de.mossgrabers.controller.push.mode.device.DeviceLayerModePan;
import de.mossgrabers.controller.push.mode.device.DeviceLayerModeSend;
import de.mossgrabers.controller.push.mode.device.DeviceLayerModeVolume;
import de.mossgrabers.controller.push.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.push.mode.track.ClipMode;
import de.mossgrabers.controller.push.mode.track.CrossfaderMode;
import de.mossgrabers.controller.push.mode.track.LayerDetailsMode;
import de.mossgrabers.controller.push.mode.track.MasterMode;
import de.mossgrabers.controller.push.mode.track.PanMode;
import de.mossgrabers.controller.push.mode.track.SendMode;
import de.mossgrabers.controller.push.mode.track.TrackDetailsMode;
import de.mossgrabers.controller.push.mode.track.TrackMode;
import de.mossgrabers.controller.push.mode.track.VolumeMode;
import de.mossgrabers.controller.push.view.ClipView;
import de.mossgrabers.controller.push.view.ColorView;
import de.mossgrabers.controller.push.view.DrumView;
import de.mossgrabers.controller.push.view.DrumView4;
import de.mossgrabers.controller.push.view.DrumView64;
import de.mossgrabers.controller.push.view.DrumView8;
import de.mossgrabers.controller.push.view.PianoView;
import de.mossgrabers.controller.push.view.PlayView;
import de.mossgrabers.controller.push.view.PrgChangeView;
import de.mossgrabers.controller.push.view.RaindropsView;
import de.mossgrabers.controller.push.view.ScenePlayView;
import de.mossgrabers.controller.push.view.SequencerView;
import de.mossgrabers.controller.push.view.SessionView;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.SceneCommand;
import de.mossgrabers.framework.command.aftertouch.AftertouchAbstractPlayViewCommand;
import de.mossgrabers.framework.command.continuous.FootswitchCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.continuous.MasterVolumeCommand;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.command.trigger.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.CursorCommand;
import de.mossgrabers.framework.command.trigger.DuplicateCommand;
import de.mossgrabers.framework.command.trigger.KnobRowTouchModeCommand;
import de.mossgrabers.framework.command.trigger.NopCommand;
import de.mossgrabers.framework.command.trigger.RepeatCommand;
import de.mossgrabers.framework.command.trigger.application.DeleteCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.ConvertCommand;
import de.mossgrabers.framework.command.trigger.clip.DoubleCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.clip.StopClipCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.view.AbstractSequencerView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;

public class PushControllerSetup
extends AbstractControllerSetup<PushControlSurface, PushConfiguration> {
    protected final boolean isPush2;

    public PushControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings, boolean isPush2) {
        super(factory, host, settings);
        this.isPush2 = isPush2;
        this.colorManager = new ColorManager();
        PushColors.addColors(this.colorManager, isPush2);
        this.valueChanger = new DefaultValueChanger(1024, 10, 1.0);
        this.configuration = new PushConfiguration(host, this.valueChanger, isPush2);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateButtons();
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        this.updateMode(surface.getModeManager().getActiveModeId());
        View activeView = surface.getViewManager().getActiveView();
        if (activeView == null) {
            return;
        }
        de.mossgrabers.framework.command.core.PitchbendCommand pitchbendCommand = activeView.getPitchbendCommand();
        if (pitchbendCommand != null) {
            pitchbendCommand.updateValue();
        }
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, this.isPush2 ? 48 : 16, this.isPush2 ? 48 : 16, false, -1, -1, -1, -1);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addTrackSelectionObserver(this::handleTrackChange);
        IChannelBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addTrackSelectionObserver(this::handleTrackChange);
        }
        this.model.getMasterTrack().addTrackSelectionObserver((index, isSelected) -> {
            PushControlSurface surface = (PushControlSurface)this.getSurface();
            ModeManager modeManager = surface.getModeManager();
            if (isSelected) {
                modeManager.setActiveMode(Modes.MODE_MASTER);
            } else if (modeManager.isActiveMode(Modes.MODE_MASTER)) {
                modeManager.restoreMode();
            }
        });
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(this.isPush2 ? "Ableton Push 2" : "Ableton Push 1", "80????", "90????", "B040??");
        PushControlSurface surface = new PushControlSurface(this.model.getHost(), this.colorManager, (PushConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
        surface.setDisplay(this.createDisplay(output));
        surface.getModeManager().setDefaultMode(Modes.MODE_TRACK);
    }

    protected PushDisplay createDisplay(IMidiOutput output) {
        return new PushDisplay(this.model.getHost(), this.isPush2, this.valueChanger.getUpperBound(), output, (PushConfiguration)this.configuration);
    }

    @Override
    protected void createModes() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_PAN, new PanMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_CROSSFADER, new CrossfaderMode(surface, this.model));
        SendMode modeSend = new SendMode(surface, this.model);
        modeManager.registerMode(Modes.MODE_SEND1, modeSend);
        modeManager.registerMode(Modes.MODE_SEND2, modeSend);
        modeManager.registerMode(Modes.MODE_SEND3, modeSend);
        modeManager.registerMode(Modes.MODE_SEND4, modeSend);
        modeManager.registerMode(Modes.MODE_SEND5, modeSend);
        modeManager.registerMode(Modes.MODE_SEND6, modeSend);
        modeManager.registerMode(Modes.MODE_SEND7, modeSend);
        modeManager.registerMode(Modes.MODE_SEND8, modeSend);
        modeManager.registerMode(Modes.MODE_MASTER, new MasterMode(surface, this.model, false));
        modeManager.registerMode(Modes.MODE_MASTER_TEMP, new MasterMode(surface, this.model, true));
        modeManager.registerMode(Modes.MODE_TRACK, new TrackMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_TRACK_DETAILS, new TrackDetailsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_DETAILS, new LayerDetailsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_CLIP, new ClipMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_NOTE, new NoteMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_FRAME, new FrameMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SCALES, new ScalesMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SCALE_LAYOUT, new ScaleLayoutMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_ACCENT, new AccentMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_FIXED, new FixedMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_RIBBON, new RibbonMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_GROOVE, new GrooveMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_VIEW_SELECT, new NoteViewSelectMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_SESSION, new SessionMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_AUTOMATION, new AutomationMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_TRANSPORT, new TransportMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_DEVICE_PARAMS, new DeviceParamsMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER, new DeviceLayerMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_BROWSER, new DeviceBrowserMode(surface, this.model));
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_VOLUME, new DeviceLayerModeVolume(surface, this.model));
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_PAN, new DeviceLayerModePan(surface, this.model));
        DeviceLayerModeSend modeLayerSend = new DeviceLayerModeSend(surface, this.model);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND1, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND2, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND3, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND4, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND5, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND6, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND7, modeLayerSend);
        modeManager.registerMode(Modes.MODE_DEVICE_LAYER_SEND8, modeLayerSend);
        if (this.isPush2) {
            modeManager.registerMode(Modes.MODE_SETUP, new SetupMode(surface, this.model));
            modeManager.registerMode(Modes.MODE_INFO, new InfoMode(surface, this.model));
        } else {
            modeManager.registerMode(Modes.MODE_CONFIGURATION, new ConfigurationMode(surface, this.model));
        }
        if (this.host.hasClips()) {
            modeManager.registerMode(Modes.MODE_SESSION_VIEW_SELECT, new SessionViewSelectMode(surface, this.model));
        }
    }

    @Override
    protected void createObservers() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        if (((PushConfiguration)this.configuration).isPush2()) {
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.DISPLAY_BRIGHTNESS, surface::sendDisplayBrightness);
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.LED_BRIGHTNESS, surface::sendLEDBrightness);
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.PAD_SENSITIVITY, () -> {
                surface.sendPadVelocityCurve();
                surface.sendPadThreshold();
            });
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.PAD_GAIN, () -> {
                surface.sendPadVelocityCurve();
                surface.sendPadThreshold();
            });
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.PAD_DYNAMICS, () -> {
                surface.sendPadVelocityCurve();
                surface.sendPadThreshold();
            });
        } else {
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.VELOCITY_CURVE, surface::sendPadSensitivity);
            ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.PAD_THRESHOLD, surface::sendPadSensitivity);
        }
        surface.getModeManager().addModeListener((oldMode, newMode) -> {
            this.updateMode(null);
            this.updateMode(newMode);
        });
        surface.getViewManager().addViewChangeListener((previousViewId, activeViewId) -> {
            View view = surface.getViewManager().getActiveView();
            for (int button : surface.getButtons()) {
                if (!surface.shouldUpdateButton(button)) continue;
                surface.setButton(button, view.usesButton(button) ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
            }
            if (Views.VIEW_SESSION.equals(activeViewId)) {
                surface.setRibbonMode(2);
            } else {
                this.updateRibbonMode();
            }
        });
        ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.RIBBON_MODE, this::updateRibbonMode);
        ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.DEBUG_MODE, () -> {
            Integer debugMode;
            ModeManager modeManager = surface.getModeManager();
            if (modeManager.getMode(debugMode = ((PushConfiguration)this.configuration).getDebugMode()) != null) {
                modeManager.setActiveMode(debugMode);
            } else {
                this.host.error("Mode " + debugMode + " not registered.");
            }
        });
        ((PushConfiguration)this.configuration).addSettingObserver(PushConfiguration.DEBUG_WINDOW, () -> ((PushDisplay)((PushControlSurface)this.getSurface()).getDisplay()).showDebugWindow());
        this.createScaleObservers(this.configuration);
    }

    @Override
    protected void createViews() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerView(Views.VIEW_PLAY, new PlayView(surface, this.model));
        viewManager.registerView(Views.VIEW_PIANO, new PianoView(surface, this.model));
        viewManager.registerView(Views.VIEW_PRG_CHANGE, new PrgChangeView(surface, this.model));
        viewManager.registerView(Views.VIEW_CLIP, new ClipView(surface, this.model));
        viewManager.registerView(Views.VIEW_COLOR, new ColorView(surface, this.model));
        if (this.host.hasClips()) {
            viewManager.registerView(Views.VIEW_SESSION, new SessionView(surface, this.model));
            viewManager.registerView(Views.VIEW_SEQUENCER, new SequencerView(surface, this.model));
            viewManager.registerView(Views.VIEW_DRUM, new DrumView(surface, this.model));
            viewManager.registerView(Views.VIEW_DRUM4, new DrumView4(surface, this.model));
            viewManager.registerView(Views.VIEW_DRUM8, new DrumView8(surface, this.model));
            viewManager.registerView(Views.VIEW_RAINDROPS, new RaindropsView(surface, this.model));
            viewManager.registerView(Views.VIEW_SCENE_PLAY, new ScenePlayView(surface, this.model));
        }
        viewManager.registerView(Views.VIEW_DRUM64, new DrumView64(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        this.addTriggerCommand(Commands.COMMAND_PLAY, 85, new PlayCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 86, new RecordCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_NEW, 87, new NewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DUPLICATE, 88, new DuplicateCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION, 89, new AutomationCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_FIXED_LENGTH, 90, new FixedLengthCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_QUANTIZE, 116, new PushQuantizeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DELETE, 118, new DeleteCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DOUBLE, 117, new DoubleCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_UNDO, 119, new UndoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DEVICE, 110, new DeviceCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_BROWSE, 111, new BrowserCommand(Modes.MODE_BROWSER, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TRACK, 112, new TrackCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_CLIP, 113, new ClipCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_VOLUME, 114, new VolumeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAN_SEND, 115, new PanSendCommand(this.model, surface));
        for (int i = 0; i < 8; ++i) {
            this.addTriggerCommand(Commands.COMMAND_ROW1_1 + i, 20 + i, new ButtonRowModeCommand(0, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_ROW2_1 + i, 102 + i, new ButtonRowModeCommand(1, i, this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SCENE1 + i, 36 + i, new SceneCommand(i, this.model, surface));
        }
        this.addTriggerCommand(Commands.COMMAND_SHIFT, 49, new ShiftCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_LAYOUT, 31, new LayoutCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT, 48, new SelectCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TAP_TEMPO, 3, new TapTempoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_METRONOME, 9, new MetronomeCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MASTERTRACK, 28, new MastertrackCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAGE_LEFT, 62, new PageLeftCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAGE_RIGHT, 63, new PageRightCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MUTE, 60, new MuteCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SOLO, 61, new SoloCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SCALES, 58, new ScalesCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ACCENT, 57, new AccentCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ADD_EFFECT, 52, new AddEffectCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ADD_TRACK, 53, new AddTrackCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT_PLAY_VIEW, 50, new SelectPlayViewCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, 47, new PushCursorCommand(CursorCommand.Direction.DOWN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, 46, new PushCursorCommand(CursorCommand.Direction.UP, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, 44, new PushCursorCommand(CursorCommand.Direction.LEFT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, 45, new PushCursorCommand(CursorCommand.Direction.RIGHT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_OCTAVE_DOWN, 54, new OctaveCommand(false, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_OCTAVE_UP, 55, new OctaveCommand(true, this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_SETUP, new SetupCommand(this.isPush2, this.model, surface));
        if (this.isPush2) {
            surface.assignTriggerCommand(30, Commands.COMMAND_SETUP);
            this.addTriggerCommand(Commands.COMMAND_CONVERT, 35, new ConvertCommand(this.model, surface));
        } else {
            surface.assignTriggerCommand(59, Commands.COMMAND_SETUP);
        }
        if (this.host.hasClips()) {
            this.addTriggerCommand(Commands.COMMAND_STOP_CLIP, 29, new StopClipCommand(this.model, surface));
            this.addTriggerCommand(Commands.COMMAND_SELECT_SESSION_VIEW, 51, new SelectSessionViewCommand(this.model, surface));
        } else {
            this.addTriggerCommand(Commands.COMMAND_SELECT_SESSION_VIEW, 51, new NopCommand(this.model, surface));
        }
        AbstractTriggerCommand repeatCommand = this.host.hasRepeat() ? new RepeatCommand(this.model, surface) : new NopCommand(this.model, surface);
        this.addTriggerCommand(Commands.COMMAND_REPEAT, 56, repeatCommand);
    }

    @Override
    protected void registerContinuousCommands() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            this.addContinuousCommand(Commands.CONT_COMMAND_KNOB1 + i, 71 + i, new KnobRowModeCommand(i, this.model, surface));
        }
        this.addContinuousCommand(Commands.CONT_COMMAND_MASTER_KNOB, 79, new MasterVolumeCommand(this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_TEMPO, 14, new RasteredKnobCommand(this.model, surface));
        this.addContinuousCommand(Commands.CONT_COMMAND_PLAY_POSITION, 15, new PlayPositionCommand(this.model, surface));
        this.addContinuousCommand(Commands.COMMAND_FOOTSWITCH, 69, new FootswitchCommand(this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB1_TOUCH, 0, new KnobRowTouchModeCommand(0, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB2_TOUCH, 1, new KnobRowTouchModeCommand(1, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB3_TOUCH, 2, new KnobRowTouchModeCommand(2, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB4_TOUCH, 3, new KnobRowTouchModeCommand(3, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB5_TOUCH, 4, new KnobRowTouchModeCommand(4, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB6_TOUCH, 5, new KnobRowTouchModeCommand(5, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB7_TOUCH, 6, new KnobRowTouchModeCommand(6, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_KNOB8_TOUCH, 7, new KnobRowTouchModeCommand(7, this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_TEMPO_TOUCH, 10, new SmallKnobTouchCommand(this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_PLAYCURSOR_TOUCH, 9, new SmallKnobTouchCommand(this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_CONFIGURE_PITCHBEND, 12, new ConfigurePitchbendCommand(this.model, surface));
        this.addNoteCommand(Commands.CONT_COMMAND_MASTERTRACK_TOUCH, 8, new MastertrackTouchCommand(this.model, surface));
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerPitchbendCommand(new PitchbendCommand(this.model, surface));
        PlayView playView = (PlayView)viewManager.getView(Views.VIEW_PLAY);
        playView.registerAftertouchCommand(new AftertouchAbstractPlayViewCommand<PushControlSurface, PushConfiguration>(playView, this.model, surface));
        PlayView pianoView = (PlayView)viewManager.getView(Views.VIEW_PIANO);
        pianoView.registerAftertouchCommand(new AftertouchAbstractPlayViewCommand<PushControlSurface, PushConfiguration>(pianoView, this.model, surface));
        if (this.host.hasClips()) {
            viewManager.getView(Views.VIEW_SESSION).registerPitchbendCommand(new PitchbendSessionCommand(this.model, surface));
        }
    }

    @Override
    public void startup() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        surface.getViewManager().setActiveView(((PushConfiguration)this.configuration).getDefaultNoteView());
        surface.sendPressureMode(true);
        surface.getOutput().sendIdentityRequest();
    }

    private void updateButtons() {
        boolean isRecordShifted;
        ITransport t = this.model.getTransport();
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        surface.updateButton(9, t.isMetronomeOn() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(85, t.isPlaying() ? "PUSH_BUTTON_STATE_PLAY_HI" : "PUSH_BUTTON_STATE_PLAY_ON");
        boolean isShift = surface.isShiftPressed();
        boolean isFlipRecord = ((PushConfiguration)this.configuration).isFlipRecord();
        boolean bl = isRecordShifted = isShift && !isFlipRecord || !isShift && isFlipRecord;
        if (isRecordShifted) {
            surface.updateButton(89, t.isWritingClipLauncherAutomation() ? "PUSH_BUTTON_STATE_REC_HI" : "PUSH_BUTTON_STATE_REC_ON");
        } else {
            surface.updateButton(89, t.isWritingArrangerAutomation() ? "PUSH_BUTTON_STATE_REC_HI" : "PUSH_BUTTON_STATE_REC_ON");
        }
        surface.updateButton(86, isRecordShifted ? (t.isLauncherOverdub() ? "PUSH_BUTTON_STATE_OVR_HI" : "PUSH_BUTTON_STATE_OVR_ON") : (t.isRecording() ? "PUSH_BUTTON_STATE_REC_HI" : "PUSH_BUTTON_STATE_REC_ON"));
        surface.updateButton(57, ((PushConfiguration)this.configuration).isAccentActive() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        PushConfiguration config = (PushConfiguration)surface.getConfiguration();
        if (this.isPush2) {
            ModeManager modeManager = surface.getModeManager();
            if (modeManager.isActiveMode(Modes.MODE_DEVICE_LAYER)) {
                ICursorDevice cd = this.model.getCursorDevice();
                IChannel layer = cd.getSelectedLayerOrDrumPad();
                surface.updateButton(60, layer != null && layer.isMute() ? "PUSH_BUTTON_STATE_MUTE_HI" : "PUSH_BUTTON_STATE_MUTE_ON");
                surface.updateButton(61, layer != null && layer.isSolo() ? "PUSH_BUTTON_STATE_SOLO_HI" : "PUSH_BUTTON_STATE_SOLO_ON");
            } else {
                ITrack selTrack = modeManager.isActiveMode(Modes.MODE_MASTER) ? this.model.getMasterTrack() : this.model.getSelectedTrack();
                surface.updateButton(60, selTrack != null && selTrack.isMute() ? "PUSH_BUTTON_STATE_MUTE_HI" : "PUSH_BUTTON_STATE_MUTE_ON");
                surface.updateButton(61, selTrack != null && selTrack.isSolo() ? "PUSH_BUTTON_STATE_SOLO_HI" : "PUSH_BUTTON_STATE_SOLO_ON");
            }
            surface.updateButton(35, this.model.canConvertClip() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        } else {
            boolean isMuteState = config.isMuteState();
            surface.updateButton(60, isMuteState ? "PUSH_BUTTON_STATE_MUTE_HI" : "PUSH_BUTTON_STATE_MUTE_ON");
            surface.updateButton(61, !isMuteState ? "PUSH_BUTTON_STATE_SOLO_HI" : "PUSH_BUTTON_STATE_SOLO_ON");
        }
        ViewManager viewManager = surface.getViewManager();
        boolean isSessionView = Views.isSessionView(viewManager.getActiveViewId());
        surface.updateButton(50, isSessionView ? "BUTTON_STATE_ON" : "BUTTON_STATE_HI");
        if (this.host.hasClips()) {
            surface.updateButton(29, surface.isPressed(29) ? "PUSH_BUTTON_STATE_STOP_HI" : "PUSH_BUTTON_STATE_STOP_ON");
            surface.updateButton(51, isSessionView ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        } else {
            surface.updateButton(29, "BUTTON_STATE_OFF");
            surface.updateButton(51, "BUTTON_STATE_OFF");
        }
        surface.updateButton(57, config.isAccentActive() ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        View activeView = viewManager.getActiveView();
        if (activeView != null) {
            ((PushCursorCommand)activeView.getTriggerCommand(Commands.COMMAND_ARROW_DOWN)).updateArrows();
            ((SceneView)((Object)activeView)).updateSceneButtons();
        }
        ICursorClip clip = activeView instanceof AbstractSequencerView && !(activeView instanceof ClipView) ? ((AbstractSequencerView)activeView).getClip() : null;
        surface.updateButton(62, clip != null && clip.canScrollStepsBackwards() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
        surface.updateButton(63, clip != null && clip.canScrollStepsForwards() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF");
    }

    private void updateMode(Integer mode) {
        if (mode == null) {
            return;
        }
        this.updateIndication(mode);
        boolean isMasterOn = Modes.MODE_MASTER.equals(mode) || Modes.MODE_MASTER_TEMP.equals(mode) || Modes.MODE_FRAME.equals(mode);
        boolean isVolumeOn = Modes.MODE_VOLUME.equals(mode) || Modes.MODE_CROSSFADER.equals(mode);
        boolean isPanOn = mode >= Modes.MODE_PAN && mode <= Modes.MODE_SEND8;
        boolean isDeviceOn = Modes.isDeviceMode(mode);
        boolean isMixOn = Modes.MODE_TRACK.equals(mode);
        if (this.isPush2) {
            isMixOn = isMixOn || isVolumeOn || isPanOn;
        }
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        surface.updateButton(28, isMasterOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(112, isMixOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(114, isVolumeOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(115, isPanOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(110, isDeviceOn ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(58, Modes.MODE_SCALES.equals(mode) ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(90, Modes.MODE_FIXED.equals(mode) ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(111, Modes.MODE_BROWSER.equals(mode) ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        surface.updateButton(113, Modes.MODE_CLIP.equals(mode) ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        if (this.isPush2) {
            surface.updateButton(30, Modes.MODE_SETUP.equals(mode) ? "BUTTON_STATE_HI" : "BUTTON_STATE_ON");
        }
    }

    private void updateIndication(Integer mode) {
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        boolean isSession = surface.getViewManager().isActiveView(Views.VIEW_SESSION);
        boolean isEffect = this.model.isEffectTrackBankActive();
        boolean isPan = Modes.MODE_PAN.equals(mode);
        boolean isVolume = Modes.MODE_VOLUME.equals(mode);
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        ITrack selectedTrack = tb.getSelectedTrack();
        for (int i = 0; i < tb.getNumTracks(); ++i) {
            boolean hasTrackSel = selectedTrack != null && selectedTrack.getIndex() == i && Modes.MODE_TRACK.equals(mode);
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect && (isVolume || hasTrackSel));
            track.setPanIndication(!isEffect && (isPan || hasTrackSel));
            for (int j = 0; j < tb.getNumSends(); ++j) {
                track.getSend(j).setIndication(!isEffect && (mode - Modes.MODE_SEND1 == j || hasTrackSel));
            }
            if (tbe != null) {
                ITrack fxTrack = tbe.getTrack(i);
                fxTrack.setVolumeIndication(isEffect);
                fxTrack.setPanIndication(isEffect && isPan);
            }
            cursorDevice.indicateParameter(i, true);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        ITrack selectedTrack;
        if (!isSelected) {
            return;
        }
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        ModeManager modeManager = surface.getModeManager();
        if (!viewManager.isActiveView(Views.VIEW_SESSION) && (selectedTrack = this.model.getSelectedTrack()) != null) {
            Integer preferredView = viewManager.getPreferredView(selectedTrack.getPosition());
            viewManager.setActiveView(preferredView == null ? ((PushConfiguration)this.configuration).getDefaultNoteView() : preferredView);
        }
        if (modeManager.isActiveMode(Modes.MODE_MASTER)) {
            modeManager.setActiveMode(Modes.MODE_TRACK);
        }
        if (viewManager.isActiveView(Views.VIEW_PLAY)) {
            viewManager.getActiveView().updateNoteMapping();
        }
        this.scales.setDrumOctave(0);
        if (viewManager.isActiveView(Views.VIEW_DRUM)) {
            viewManager.getView(Views.VIEW_DRUM).updateNoteMapping();
        }
    }

    private void updateRibbonMode() {
        PushControlSurface surface = (PushControlSurface)this.getSurface();
        surface.setRibbonValue(0);
        switch (((PushConfiguration)this.configuration).getRibbonMode()) {
            case 1: 
            case 4: {
                surface.setRibbonMode(1);
                break;
            }
            default: {
                surface.setRibbonMode(0);
            }
        }
    }
}

