/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.usb.USBMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class PushControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID_MK_I = UUID.fromString("DBED9610-C474-11E6-9598-0800200C9A66");
    private static final UUID EXTENSION_ID_MK_II = UUID.fromString("15176AA0-C476-11E6-9598-0800200C9A66");
    private static final short VENDOR_ID = 10626;
    private static final short PRODUCT_ID = 6503;
    private static final byte INTERFACE_NUMBER = 0;
    private static final byte ENDPOINT_ADDRESS = 1;
    private boolean isMkII;

    public PushControllerDefinition(boolean isMkII) {
        super("", "J\u00fcrgen Mo\u00dfgraber", "10.00", isMkII ? EXTENSION_ID_MK_II : EXTENSION_ID_MK_I, isMkII ? "Push 2" : "Push 1", "Ableton", 1, 1);
        this.isMkII = isMkII;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                if (this.isMkII) {
                    midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Ableton Push 2"));
                    break;
                }
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("MIDIIN2 (Ableton Push)", "MIDIOUT2 (Ableton Push)"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(this.isMkII ? "Ableton Push 2 MIDI 1" : "Ableton Push MIDI 2"));
                break;
            }
            case MAC: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(this.isMkII ? "Ableton Push 2 Live Port" : "Ableton Push User Port"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public USBMatcher claimUSBDevice() {
        return this.isMkII ? new USBMatcher(10626, 6503, 0, 1, true) : null;
    }
}

