/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.push;

import de.mossgrabers.controller.push.controller.PushControlSurface;
import de.mossgrabers.controller.push.mode.Modes;
import de.mossgrabers.controller.push.view.Views;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import java.util.Set;

public class PushConfiguration
extends AbstractConfiguration {
    public static final Integer RIBBON_MODE = 30;
    public static final Integer RIBBON_MODE_CC_VAL = 31;
    public static final Integer VELOCITY_CURVE = 32;
    public static final Integer PAD_THRESHOLD = 33;
    public static final Integer DISPLAY_BRIGHTNESS = 34;
    public static final Integer LED_BRIGHTNESS = 35;
    public static final Integer PAD_SENSITIVITY = 36;
    public static final Integer PAD_GAIN = 37;
    public static final Integer PAD_DYNAMICS = 38;
    public static final Integer STOP_AUTOMATION_ON_KNOB_RELEASE = 39;
    public static final Integer DEFAULT_NOTE_VIEW = 40;
    public static final Integer DEBUG_MODE = 41;
    public static final Integer DEBUG_WINDOW = 42;
    public static final Integer COLOR_BACKGROUND = 50;
    public static final Integer COLOR_BORDER = 51;
    public static final Integer COLOR_TEXT = 52;
    public static final Integer COLOR_FADER = 53;
    public static final Integer COLOR_VU = 54;
    public static final Integer COLOR_EDIT = 55;
    public static final Integer COLOR_RECORD = 56;
    public static final Integer COLOR_SOLO = 57;
    public static final Integer COLOR_MUTE = 58;
    public static final Integer COLOR_BACKGROUND_DARKER = 59;
    public static final Integer COLOR_BACKGROUND_LIGHTER = 60;
    private static final ColorEx DEFAULT_COLOR_BACKGROUND = ColorEx.fromRGB(83, 83, 83);
    private static final ColorEx DEFAULT_COLOR_BORDER = ColorEx.BLACK;
    private static final ColorEx DEFAULT_COLOR_TEXT = ColorEx.WHITE;
    private static final ColorEx DEFAULT_COLOR_FADER = ColorEx.fromRGB(69, 44, 19);
    private static final ColorEx DEFAULT_COLOR_VU = ColorEx.GREEN;
    private static final ColorEx DEFAULT_COLOR_EDIT = ColorEx.fromRGB(240, 127, 17);
    private static final ColorEx DEFAULT_COLOR_RECORD = ColorEx.RED;
    private static final ColorEx DEFAULT_COLOR_SOLO = ColorEx.YELLOW;
    private static final ColorEx DEFAULT_COLOR_MUTE = ColorEx.fromRGB(245, 129, 17);
    private static final ColorEx DEFAULT_COLOR_BACKGROUND_DARKER = ColorEx.fromRGB(58, 58, 58);
    private static final ColorEx DEFAULT_COLOR_BACKGROUND_LIGHTER = ColorEx.fromRGB(118, 118, 118);
    public static final int RIBBON_MODE_PITCH = 0;
    public static final int RIBBON_MODE_CC = 1;
    public static final int RIBBON_MODE_CC_PB = 2;
    public static final int RIBBON_MODE_PB_CC = 3;
    public static final int RIBBON_MODE_FADER = 4;
    private boolean isSoloLongPressed = false;
    private boolean isMuteLongPressed = false;
    private boolean isMuteSoloLocked = false;
    private static final String CATEGORY_RIBBON = "Ribbon";
    private static final String CATEGORY_COLORS = "Display Colors";
    private static final String[] RIBBON_MODE_VALUES = new String[]{"Pitch", "CC", "CC/Pitch", "Pitch/CC", "Fader"};
    private Integer defaultNoteView = Views.VIEW_PLAY;
    private int ribbonMode = 0;
    private int ribbonModeCCVal = 1;
    private boolean stopAutomationOnKnobRelease = false;
    private TrackState trackState = TrackState.MUTE;
    private Integer debugMode = Modes.MODE_TRACK;
    private int velocityCurve = 1;
    private int padThreshold = 20;
    private boolean sendsAreToggled = false;
    private int displayBrightness = 255;
    private int ledBrightness = 127;
    private int padSensitivity = 5;
    private int padGain = 5;
    private int padDynamics = 5;
    private ColorEx colorBackground = DEFAULT_COLOR_BACKGROUND;
    private ColorEx colorBorder = DEFAULT_COLOR_BORDER;
    private ColorEx colorText = DEFAULT_COLOR_TEXT;
    private ColorEx colorFader = DEFAULT_COLOR_FADER;
    private ColorEx colorVU = DEFAULT_COLOR_VU;
    private ColorEx colorEdit = DEFAULT_COLOR_EDIT;
    private ColorEx colorRecord = DEFAULT_COLOR_RECORD;
    private ColorEx colorSolo = DEFAULT_COLOR_SOLO;
    private ColorEx colorMute = DEFAULT_COLOR_MUTE;
    private ColorEx colorBackgroundDarker = DEFAULT_COLOR_BACKGROUND_DARKER;
    private ColorEx colorBackgroundLighter = DEFAULT_COLOR_BACKGROUND_LIGHTER;
    private final IHost host;
    private final boolean isPush2;
    private IIntegerSetting displayBrightnessSetting;
    private IIntegerSetting ledBrightnessSetting;
    private IEnumSetting ribbonModeSetting;
    private IIntegerSetting ribbonModeCCSetting;
    private IIntegerSetting padSensitivitySetting;
    private IIntegerSetting padGainSetting;
    private IIntegerSetting padDynamicsSetting;
    private IEnumSetting velocityCurveSetting;
    private IEnumSetting padThresholdSetting;
    private IEnumSetting debugModeSetting;
    private IColorSetting colorBackgroundSetting;
    private IColorSetting colorBackgroundDarkerSetting;
    private IColorSetting colorBackgroundLighterSetting;
    private IColorSetting colorBorderSetting;
    private IColorSetting colorTextSetting;
    private IColorSetting colorFaderSetting;
    private IColorSetting colorVUSetting;
    private IColorSetting colorEditSetting;
    private IColorSetting colorRecordSetting;
    private IColorSetting colorSoloSetting;
    private IColorSetting colorMuteSetting;

    public PushConfiguration(IHost host, IValueChanger valueChanger, boolean isPush2) {
        super(valueChanger);
        this.host = host;
        this.isPush2 = isPush2;
        Views.init(host);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        this.activateScaleSetting(settingsUI);
        this.activateScaleBaseSetting(settingsUI);
        this.activateScaleInScaleSetting(settingsUI);
        this.activateScaleLayoutSetting(settingsUI);
        if (this.host.hasClips()) {
            this.activateFlipSessionSetting(settingsUI);
            this.activateLockFlipSessionSetting(settingsUI);
            this.activateSelectClipOnLaunchSetting(settingsUI);
            this.activateDrawRecordStripeSetting(settingsUI);
            this.activateActionForRecArmedPad(settingsUI);
        }
        this.activateBehaviourOnStopSetting(settingsUI);
        if (this.host.hasClips()) {
            this.activateFlipRecordSetting(settingsUI);
        }
        this.activateAccentActiveSetting(settingsUI);
        this.activateAccentValueSetting(settingsUI);
        this.activateQuantizeAmountSetting(settingsUI);
        this.activateDefaultNoteViewSetting(settingsUI);
        if (this.host.hasDrumDevice()) {
            this.activateAutoSelectDrumSetting(settingsUI);
            this.activateTurnOffEmptyDrumPadsSetting(settingsUI);
        }
        this.activateEnableVUMetersSetting(settingsUI);
        if (this.host.hasCrossfader()) {
            this.activateDisplayCrossfaderSetting(settingsUI);
        } else {
            this.displayCrossfader = false;
        }
        this.activateFootswitchSetting(settingsUI);
        this.activateStopAutomationOnKnobReleaseSetting(settingsUI);
        this.activateNewClipLengthSetting(settingsUI);
        this.activateRibbonSettings(settingsUI);
        if (this.isPush2) {
            this.activatePush2PadSettings(settingsUI);
        } else {
            this.activatePush1PadSettings(settingsUI);
        }
        this.activateConvertAftertouchSetting(settingsUI);
        this.activateBrowserSettings(settingsUI);
        this.activatePush2HardwareSettings(settingsUI);
        this.activatePush2DisplayColorsSettings(settingsUI);
        this.activateDebugSettings(settingsUI);
    }

    public void setRibbonMode(int mode) {
        this.ribbonModeSetting.set(RIBBON_MODE_VALUES[mode]);
    }

    public int getRibbonMode() {
        return this.ribbonMode;
    }

    public void setRibbonModeCC(int value) {
        this.ribbonModeCCSetting.set(value);
    }

    public int getRibbonModeCCVal() {
        return this.ribbonModeCCVal;
    }

    public void changePadThreshold(int control) {
        int value = this.valueChanger.changeValue(control, this.padThreshold, 1.0, PushControlSurface.PUSH_PAD_THRESHOLDS_NAME.length);
        this.padThreshold = Math.max(0, Math.min(value, PushControlSurface.PUSH_PAD_THRESHOLDS_NAME.length - 1));
        this.padThresholdSetting.set(PushControlSurface.PUSH_PAD_THRESHOLDS_NAME[this.padThreshold]);
    }

    public void changeVelocityCurve(int control) {
        int value = this.valueChanger.changeValue(control, this.velocityCurve, 1.0, PushControlSurface.PUSH_PAD_CURVES_NAME.length);
        this.velocityCurve = Math.max(0, Math.min(value, PushControlSurface.PUSH_PAD_CURVES_NAME.length - 1));
        this.velocityCurveSetting.set(PushControlSurface.PUSH_PAD_CURVES_NAME[this.velocityCurve]);
    }

    public void changeDisplayBrightness(int control) {
        this.displayBrightnessSetting.set(this.valueChanger.changeValue(control, this.displayBrightness, 1.0, 101));
    }

    public void changeLEDBrightness(int control) {
        this.ledBrightnessSetting.set(this.valueChanger.changeValue(control, this.ledBrightness, 1.0, 101));
    }

    public void changePadSensitivity(int control) {
        this.padSensitivitySetting.set(this.valueChanger.changeValue(control, this.padSensitivity, 1.0, 11));
    }

    public void changePadGain(int control) {
        this.padGainSetting.set(this.valueChanger.changeValue(control, this.padGain, 1.0, 11));
    }

    public void changePadDynamics(int control) {
        this.padDynamicsSetting.set(this.valueChanger.changeValue(control, this.padDynamics, 1.0, 11));
    }

    public boolean isPush2() {
        return this.isPush2;
    }

    public int getVelocityCurve() {
        return this.velocityCurve;
    }

    public void setVelocityCurve(int velocityCurve) {
        this.velocityCurve = velocityCurve;
    }

    public int getPadThreshold() {
        return this.padThreshold;
    }

    public void setPadThreshold(int padThreshold) {
        this.padThreshold = padThreshold;
    }

    public int getDisplayBrightness() {
        return this.displayBrightness;
    }

    public void setDisplayBrightness(int displayBrightness) {
        this.displayBrightness = displayBrightness;
    }

    public int getLedBrightness() {
        return this.ledBrightness;
    }

    public void setLedBrightness(int ledBrightness) {
        this.ledBrightness = ledBrightness;
    }

    public boolean isStopAutomationOnKnobRelease() {
        return this.stopAutomationOnKnobRelease;
    }

    public boolean isSendsAreToggled() {
        return this.sendsAreToggled;
    }

    public void setSendsAreToggled(boolean sendsAreToggled) {
        this.sendsAreToggled = sendsAreToggled;
    }

    public boolean isMuteLongPressed() {
        return this.isMuteLongPressed;
    }

    public void setIsMuteLongPressed(boolean isMuteLongPressed) {
        this.isMuteLongPressed = isMuteLongPressed;
    }

    public boolean isSoloLongPressed() {
        return this.isSoloLongPressed;
    }

    public void setIsSoloLongPressed(boolean isSoloLongPressed) {
        this.isSoloLongPressed = isSoloLongPressed;
    }

    public boolean isMuteSoloLocked() {
        return this.isMuteSoloLocked;
    }

    public void setMuteSoloLocked(boolean isMuteSoloLocked) {
        this.isMuteSoloLocked = isMuteSoloLocked;
    }

    public int getPadSensitivity() {
        return this.padSensitivity;
    }

    public void setPadSensitivity(int padSensitivity) {
        this.padSensitivity = padSensitivity;
    }

    public int getPadGain() {
        return this.padGain;
    }

    public void setPadGain(int padGain) {
        this.padGain = padGain;
    }

    public int getPadDynamics() {
        return this.padDynamics;
    }

    public void setPadDynamics(int padDynamics) {
        this.padDynamics = padDynamics;
    }

    public boolean isMuteState() {
        return this.trackState == TrackState.MUTE;
    }

    public boolean isSoloState() {
        return this.trackState == TrackState.SOLO;
    }

    public void setTrackState(TrackState state) {
        this.trackState = state;
    }

    public Integer getCurrentMixMode() {
        return Modes.isTrackMode(this.debugMode) ? this.debugMode : null;
    }

    public Integer getDefaultNoteView() {
        return this.defaultNoteView;
    }

    public ColorEx getColorBackground() {
        return this.colorBackground;
    }

    public ColorEx getColorBackgroundDarker() {
        return this.colorBackgroundDarker;
    }

    public ColorEx getColorBackgroundLighter() {
        return this.colorBackgroundLighter;
    }

    public ColorEx getColorBorder() {
        return this.colorBorder;
    }

    public ColorEx getColorText() {
        return this.colorText;
    }

    public ColorEx getColorEdit() {
        return this.colorEdit;
    }

    public ColorEx getColorFader() {
        return this.colorFader;
    }

    public ColorEx getColorVu() {
        return this.colorVU;
    }

    public ColorEx getColorRecord() {
        return this.colorRecord;
    }

    public ColorEx getColorSolo() {
        return this.colorSolo;
    }

    public ColorEx getColorMute() {
        return this.colorMute;
    }

    public Integer getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(Integer debugMode) {
        this.debugModeSetting.set(debugMode.toString());
    }

    private void activatePush2HardwareSettings(ISettingsUI settingsUI) {
        if (!this.isPush2) {
            return;
        }
        this.displayBrightnessSetting = settingsUI.getRangeSetting("Display Brightness", "Hardware Setup", 0, 100, 1, "%", 100);
        this.displayBrightnessSetting.addValueObserver(value -> {
            this.displayBrightness = value;
            this.notifyObservers(DISPLAY_BRIGHTNESS);
        });
        this.ledBrightnessSetting = settingsUI.getRangeSetting("LED Brightness", "Hardware Setup", 0, 100, 1, "%", 100);
        this.ledBrightnessSetting.addValueObserver(value -> {
            this.ledBrightness = value;
            this.notifyObservers(LED_BRIGHTNESS);
        });
    }

    private void activateRibbonSettings(ISettingsUI settingsUI) {
        this.ribbonModeSetting = settingsUI.getEnumSetting("Mode", CATEGORY_RIBBON, RIBBON_MODE_VALUES, RIBBON_MODE_VALUES[0]);
        this.ribbonModeSetting.addValueObserver(value -> {
            this.ribbonMode = PushConfiguration.lookupIndex(RIBBON_MODE_VALUES, value);
            this.notifyObservers(RIBBON_MODE);
        });
        this.ribbonModeCCSetting = settingsUI.getRangeSetting("CC", CATEGORY_RIBBON, 0, 127, 1, "", 1);
        this.ribbonModeCCSetting.addValueObserver(value -> {
            this.ribbonModeCCVal = value;
            this.notifyObservers(RIBBON_MODE_CC_VAL);
        });
    }

    private void activateStopAutomationOnKnobReleaseSetting(ISettingsUI settingsUI) {
        settingsUI.getEnumSetting("Stop automation recording on knob release", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]).addValueObserver(value -> {
            this.stopAutomationOnKnobRelease = "On".equals(value);
            this.notifyObservers(STOP_AUTOMATION_ON_KNOB_RELEASE);
        });
    }

    private void activatePush1PadSettings(ISettingsUI settingsUI) {
        this.velocityCurveSetting = settingsUI.getEnumSetting("Velocity Curve", "Pads", PushControlSurface.PUSH_PAD_CURVES_NAME, PushControlSurface.PUSH_PAD_CURVES_NAME[1]);
        this.velocityCurveSetting.addValueObserver(value -> {
            this.velocityCurve = PushConfiguration.lookupIndex(PushControlSurface.PUSH_PAD_CURVES_NAME, value);
            this.notifyObservers(VELOCITY_CURVE);
        });
        this.padThresholdSetting = settingsUI.getEnumSetting("Pad Threshold", "Pads", PushControlSurface.PUSH_PAD_THRESHOLDS_NAME, PushControlSurface.PUSH_PAD_THRESHOLDS_NAME[20]);
        this.padThresholdSetting.addValueObserver(value -> {
            this.padThreshold = PushConfiguration.lookupIndex(PushControlSurface.PUSH_PAD_THRESHOLDS_NAME, value);
            this.notifyObservers(PAD_THRESHOLD);
        });
    }

    private void activatePush2PadSettings(ISettingsUI settingsUI) {
        this.padSensitivitySetting = settingsUI.getRangeSetting("Sensitivity", "Pads", 0, 10, 1, "", 5);
        this.padSensitivitySetting.addValueObserver(value -> {
            this.padSensitivity = value;
            this.notifyObservers(PAD_SENSITIVITY);
        });
        this.padGainSetting = settingsUI.getRangeSetting("Gain", "Pads", 0, 10, 1, "", 5);
        this.padGainSetting.addValueObserver(value -> {
            this.padGain = value;
            this.notifyObservers(PAD_GAIN);
        });
        this.padDynamicsSetting = settingsUI.getRangeSetting("Dynamics", "Pads", 0, 10, 1, "", 5);
        this.padDynamicsSetting.addValueObserver(value -> {
            this.padDynamics = value;
            this.notifyObservers(PAD_DYNAMICS);
        });
    }

    private void activateDefaultNoteViewSetting(ISettingsUI settingsUI) {
        String[] noteViewNames = Views.getNoteViewNames();
        IEnumSetting defaultNoteViewSetting = settingsUI.getEnumSetting("Default note view", "Play and Sequence", noteViewNames, noteViewNames[0]);
        defaultNoteViewSetting.addValueObserver(value -> {
            for (int i = 0; i < noteViewNames.length; ++i) {
                if (!noteViewNames[i].equals(value)) continue;
                this.defaultNoteView = Views.getNoteView(i);
            }
            this.notifyObservers(DEFAULT_NOTE_VIEW);
        });
    }

    private void activatePush2DisplayColorsSettings(ISettingsUI settingsUI) {
        if (!this.isPush2) {
            return;
        }
        settingsUI.getSignalSetting("Reset colors to default", CATEGORY_COLORS, "Reset").addValueObserver(value -> {
            this.colorBackgroundSetting.set(DEFAULT_COLOR_BACKGROUND);
            this.colorBackgroundDarkerSetting.set(DEFAULT_COLOR_BACKGROUND_DARKER);
            this.colorBackgroundLighterSetting.set(DEFAULT_COLOR_BACKGROUND_LIGHTER);
            this.colorBorderSetting.set(DEFAULT_COLOR_BORDER);
            this.colorTextSetting.set(DEFAULT_COLOR_TEXT);
            this.colorFaderSetting.set(DEFAULT_COLOR_FADER);
            this.colorVUSetting.set(DEFAULT_COLOR_VU);
            this.colorEditSetting.set(DEFAULT_COLOR_EDIT);
            this.colorRecordSetting.set(DEFAULT_COLOR_RECORD);
            this.colorSoloSetting.set(DEFAULT_COLOR_SOLO);
            this.colorMuteSetting.set(DEFAULT_COLOR_MUTE);
        });
        this.colorBackgroundSetting = settingsUI.getColorSetting("Background", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND);
        this.colorBackgroundSetting.addValueObserver(color -> {
            this.colorBackground = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_BACKGROUND);
        });
        this.colorBackgroundDarkerSetting = settingsUI.getColorSetting("Background Darker", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND_DARKER);
        this.colorBackgroundDarkerSetting.addValueObserver(color -> {
            this.colorBackgroundDarker = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_BACKGROUND_DARKER);
        });
        this.colorBackgroundLighterSetting = settingsUI.getColorSetting("Background Selected", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND_LIGHTER);
        this.colorBackgroundLighterSetting.addValueObserver(color -> {
            this.colorBackgroundLighter = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_BACKGROUND_LIGHTER);
        });
        this.colorBorderSetting = settingsUI.getColorSetting("Border", CATEGORY_COLORS, DEFAULT_COLOR_BORDER);
        this.colorBorderSetting.addValueObserver(color -> {
            this.colorBorder = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_BORDER);
        });
        this.colorTextSetting = settingsUI.getColorSetting("Text", CATEGORY_COLORS, DEFAULT_COLOR_TEXT);
        this.colorTextSetting.addValueObserver(color -> {
            this.colorText = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_TEXT);
        });
        this.colorFaderSetting = settingsUI.getColorSetting("Fader", CATEGORY_COLORS, DEFAULT_COLOR_FADER);
        this.colorFaderSetting.addValueObserver(color -> {
            this.colorFader = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_FADER);
        });
        this.colorVUSetting = settingsUI.getColorSetting("VU", CATEGORY_COLORS, DEFAULT_COLOR_VU);
        this.colorVUSetting.addValueObserver(color -> {
            this.colorVU = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_VU);
        });
        this.colorEditSetting = settingsUI.getColorSetting("Edit", CATEGORY_COLORS, DEFAULT_COLOR_EDIT);
        this.colorEditSetting.addValueObserver(color -> {
            this.colorEdit = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_EDIT);
        });
        this.colorRecordSetting = settingsUI.getColorSetting("Record", CATEGORY_COLORS, DEFAULT_COLOR_RECORD);
        this.colorRecordSetting.addValueObserver(color -> {
            this.colorRecord = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_RECORD);
        });
        this.colorSoloSetting = settingsUI.getColorSetting("Solo", CATEGORY_COLORS, DEFAULT_COLOR_SOLO);
        this.colorSoloSetting.addValueObserver(color -> {
            this.colorSolo = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_SOLO);
        });
        this.colorMuteSetting = settingsUI.getColorSetting("Mute", CATEGORY_COLORS, DEFAULT_COLOR_MUTE);
        this.colorMuteSetting.addValueObserver(color -> {
            this.colorMute = new ColorEx(color[0], color[1], color[2]);
            this.notifyObservers(COLOR_MUTE);
        });
    }

    private void activateDebugSettings(ISettingsUI settingsUI) {
        Set<Integer> allModes = Modes.ALL_MODES;
        String[] modes = new String[allModes.size()];
        int i = 0;
        for (Integer mode : allModes) {
            modes[i] = mode.toString();
            ++i;
        }
        this.debugModeSetting = settingsUI.getEnumSetting("Display Mode", "Debug", modes, Modes.MODE_TRACK.toString());
        this.debugModeSetting.addValueObserver(value -> {
            this.debugMode = Integer.valueOf(value);
            this.notifyObservers(DEBUG_MODE);
        });
        if (!this.isPush2) {
            return;
        }
        settingsUI.getSignalSetting(" ", "Debug", "Display window").addValueObserver(value -> this.notifyObservers(DEBUG_WINDOW));
    }

    public static enum TrackState {
        NONE,
        MUTE,
        SOLO;

    }
}

