/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.protocol;

import de.mossgrabers.controller.osc.OSCColors;
import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.protocol.KeyManager;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ISceneBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.EmptyTrackData;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlWriter;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.scale.Scales;

public class OSCWriter
extends AbstractOpenSoundControlWriter {
    private KeyManager keyManager;

    public OSCWriter(IHost host, IModel model, IOpenSoundControlServer oscServer, KeyManager keyManager, OSCConfiguration configuration) {
        super(host, model, oscServer, configuration);
        this.keyManager = keyManager;
    }

    @Override
    public void flush(boolean dump) {
        int i;
        if (!this.isConnected()) {
            return;
        }
        ITransport trans = this.model.getTransport();
        this.sendOSC("/play", trans.isPlaying(), dump);
        this.sendOSC("/record", trans.isRecording(), dump);
        this.sendOSC("/overdub", trans.isArrangerOverdub(), dump);
        this.sendOSC("/overdub/launcher", trans.isLauncherOverdub(), dump);
        this.sendOSC("/repeat", trans.isLoop(), dump);
        this.sendOSC("/punchIn", trans.isPunchInEnabled(), dump);
        this.sendOSC("/punchOut", trans.isPunchOutEnabled(), dump);
        this.sendOSC("/click", trans.isMetronomeOn(), dump);
        this.sendOSC("/click/ticks", trans.isMetronomeTicksOn(), dump);
        this.sendOSC("/click/volume", trans.getMetronomeVolume(), dump);
        this.sendOSC("/click/volumeStr", trans.getMetronomeVolumeStr(), dump);
        this.sendOSC("/click/preroll", trans.isPrerollMetronomeEnabled(), dump);
        this.sendOSC("/preroll", trans.getPrerollAsBars(), dump);
        this.sendOSC("/tempo/raw", trans.getTempo(), dump);
        this.sendOSC("/crossfade", trans.getCrossfade(), dump);
        this.sendOSC("/autowrite", trans.isWritingArrangerAutomation(), dump);
        this.sendOSC("/autowrite/launcher", trans.isWritingClipLauncherAutomation(), dump);
        this.sendOSC("/automationWriteMode", trans.getAutomationWriteMode(), dump);
        this.sendOSC("/time/str", trans.getPositionText(), dump);
        this.sendOSC("/time/signature", trans.getNumerator() + " / " + trans.getDenominator(), dump);
        this.sendOSC("/beat/str", trans.getBeatText(), dump);
        IApplication app = this.model.getApplication();
        this.sendOSC("/layout", app.getPanelLayout().toLowerCase(), dump);
        IArranger arrange = this.model.getArranger();
        this.sendOSC("/arranger/cueMarkerVisibility", arrange.areCueMarkersVisible(), dump);
        this.sendOSC("/arranger/playbackFollow", arrange.isPlaybackFollowEnabled(), dump);
        this.sendOSC("/arranger/trackRowHeight", arrange.hasDoubleRowTrackHeight(), dump);
        this.sendOSC("/arranger/clipLauncherSectionVisibility", arrange.isClipLauncherVisible(), dump);
        this.sendOSC("/arranger/timeLineVisibility", arrange.isTimelineVisible(), dump);
        this.sendOSC("/arranger/ioSectionVisibility", arrange.isIoSectionVisible(), dump);
        this.sendOSC("/arranger/effectTracksVisibility", arrange.areEffectTracksVisible(), dump);
        IMixer mix = this.model.getMixer();
        this.sendOSC("/mixer/clipLauncherSectionVisibility", mix.isClipLauncherSectionVisible(), dump);
        this.sendOSC("/mixer/crossFadeSectionVisibility", mix.isCrossFadeSectionVisible(), dump);
        this.sendOSC("/mixer/deviceSectionVisibility", mix.isDeviceSectionVisible(), dump);
        this.sendOSC("/mixer/sendsSectionVisibility", mix.isSendSectionVisible(), dump);
        this.sendOSC("/mixer/ioSectionVisibility", mix.isIoSectionVisible(), dump);
        this.sendOSC("/mixer/meterSectionVisibility", mix.isMeterSectionVisible(), dump);
        this.sendOSC("/project/name", this.model.getProject().getName(), dump);
        this.sendOSC("/project/engine", app.isEngineActive(), dump);
        IChannelBank trackBank = this.model.getCurrentTrackBank();
        for (int i2 = 0; i2 < trackBank.getNumTracks(); ++i2) {
            this.flushTrack("/track/" + (i2 + 1) + "/", trackBank.getTrack(i2), dump);
        }
        this.flushTrack("/master/", this.model.getMasterTrack(), dump);
        ITrack selectedTrack = trackBank.getSelectedTrack();
        this.flushTrack("/track/selected/", selectedTrack == null ? EmptyTrackData.INSTANCE : selectedTrack, dump);
        this.sendOSC("/track/toggleBank", this.model.isEffectTrackBankActive() ? 1 : 0, dump);
        ISceneBank sceneBank = this.model.getSceneBank();
        if (sceneBank != null) {
            for (int i3 = 0; i3 < sceneBank.getNumScenes(); ++i3) {
                this.flushScene("/scene/" + (i3 + 1) + "/", sceneBank.getScene(i3), dump);
            }
        }
        ICursorDevice cd = this.model.getCursorDevice();
        this.flushDevice("/device/", cd, dump);
        if (cd.hasDrumPads()) {
            for (i = 0; i < cd.getNumDrumPads(); ++i) {
                this.flushDeviceLayers("/device/drumpad/" + (i + 1) + "/", cd.getLayerOrDrumPad(i), dump);
            }
        }
        for (i = 0; i < cd.getNumLayers(); ++i) {
            this.flushDeviceLayers("/device/layer/" + (i + 1) + "/", cd.getLayerOrDrumPad(i), dump);
        }
        this.flushDevice("/primary/", this.model.getPrimaryDevice(), dump);
        this.flushBrowser("/browser/", this.model.getBrowser(), dump);
        this.flushNotes("/vkb_midi/note/", dump);
        this.flush();
    }

    private void flushTrack(String trackAddress, ITrack track, boolean dump) {
        int i;
        this.sendOSC(trackAddress + "exists", track.doesExist(), dump);
        ChannelType type = track.getType();
        this.sendOSC(trackAddress + "type", type == null ? null : type.name().toLowerCase(), dump);
        this.sendOSC(trackAddress + "activated", track.isActivated(), dump);
        this.sendOSC(trackAddress + "selected", track.isSelected(), dump);
        this.sendOSC(trackAddress + "isGroup", track.isGroup(), dump);
        this.sendOSC(trackAddress + "name", track.getName(), dump);
        this.sendOSC(trackAddress + "volumeStr", track.getVolumeStr(), dump);
        this.sendOSC(trackAddress + "volume", track.getVolume(), dump);
        this.sendOSC(trackAddress + "panStr", track.getPanStr(), dump);
        this.sendOSC(trackAddress + "pan", track.getPan(), dump);
        this.sendOSC(trackAddress + "mute", track.isMute(), dump);
        this.sendOSC(trackAddress + "solo", track.isSolo(), dump);
        this.sendOSC(trackAddress + "recarm", track.isRecArm(), dump);
        this.sendOSC(trackAddress + "monitor", track.isMonitor(), dump);
        this.sendOSC(trackAddress + "autoMonitor", track.isAutoMonitor(), dump);
        this.sendOSC(trackAddress + "canHoldNotes", track.canHoldNotes(), dump);
        this.sendOSC(trackAddress + "canHoldAudioData", track.canHoldAudioData(), dump);
        this.sendOSC(trackAddress + "position", track.getPosition(), dump);
        for (i = 0; i < track.getNumSends(); ++i) {
            this.flushParameterData(trackAddress + "send/" + (i + 1) + "/", track.getSend(i), dump);
        }
        for (i = 0; i < track.getNumSlots(); ++i) {
            ISlot slot = track.getSlot(i);
            String clipAddress = trackAddress + "clip/" + (i + 1) + "/";
            this.sendOSC(clipAddress + "name", slot.getName(), dump);
            this.sendOSC(clipAddress + "isSelected", slot.isSelected(), dump);
            this.sendOSC(clipAddress + "hasContent", slot.hasContent(), dump);
            this.sendOSC(clipAddress + "isPlaying", slot.isPlaying(), dump);
            this.sendOSC(clipAddress + "isRecording", slot.isRecording(), dump);
            this.sendOSC(clipAddress + "isPlayingQueued", slot.isPlayingQueued(), dump);
            this.sendOSC(clipAddress + "isRecordingQueued", slot.isRecordingQueued(), dump);
            this.sendOSC(clipAddress + "isStopQueued", slot.isStopQueued(), dump);
            double[] color = slot.getColor();
            this.sendOSCColor(clipAddress + "color", color[0], color[1], color[2], dump);
        }
        double[] color = track.getColor();
        this.sendOSCColor(trackAddress + "color", color[0], color[1], color[2], dump);
        String crossfadeMode = track.getCrossfadeMode();
        this.sendOSC(trackAddress + "crossfadeMode/A", "A".equals(crossfadeMode), dump);
        this.sendOSC(trackAddress + "crossfadeMode/B", "B".equals(crossfadeMode), dump);
        this.sendOSC(trackAddress + "crossfadeMode/AB", "AB".equals(crossfadeMode), dump);
        this.sendOSC(trackAddress + "vu", ((OSCConfiguration)this.configuration).isEnableVUMeters() ? track.getVu() : 0, dump);
    }

    private void flushScene(String sceneAddress, IScene scene, boolean dump) {
        this.sendOSC(sceneAddress + "exists", scene.doesExist(), dump);
        this.sendOSC(sceneAddress + "name", scene.getName(), dump);
        this.sendOSC(sceneAddress + "selected", scene.isSelected(), dump);
    }

    private void flushDevice(String deviceAddress, ICursorDevice device, boolean dump) {
        int oneplus;
        int i;
        this.sendOSC(deviceAddress + "exists", device.doesExist(), dump);
        this.sendOSC(deviceAddress + "name", device.getName(), dump);
        this.sendOSC(deviceAddress + "bypass", !device.isEnabled(), dump);
        this.sendOSC(deviceAddress + "expand", device.isExpanded(), dump);
        this.sendOSC(deviceAddress + "window", device.isWindowOpen(), dump);
        int positionInBank = device.getPositionInBank();
        for (i = 0; i < device.getNumDevices(); ++i) {
            oneplus = i + 1;
            this.sendOSC(deviceAddress + "sibling/" + oneplus + "/name", device.getSiblingDeviceName(i), dump);
            this.sendOSC(deviceAddress + "sibling/" + oneplus + "/selected", i == positionInBank, dump);
        }
        for (i = 0; i < device.getNumParameters(); ++i) {
            oneplus = i + 1;
            this.flushParameterData(deviceAddress + "param/" + oneplus + "/", device.getFXParam(i), dump);
        }
        String[] parameterPageNames = device.getParameterPageNames();
        int selectedParameterPage = device.getSelectedParameterPage();
        int page = Math.min(Math.max(0, selectedParameterPage), parameterPageNames.length - 1);
        int start = page / 8 * 8;
        for (int i2 = 0; i2 < 8; ++i2) {
            int index = start + i2;
            String pageName = index < parameterPageNames.length ? parameterPageNames[index] : "";
            int oneplus2 = i2 + 1;
            this.sendOSC(deviceAddress + "page/" + oneplus2 + "/", pageName, dump);
            this.sendOSC(deviceAddress + "page/" + oneplus2 + "/selected", page == index, dump);
        }
        int sel = page % 8;
        this.sendOSC(deviceAddress + "page/selected/name", sel >= 0 && sel < 8 ? parameterPageNames[sel] : "", dump);
    }

    private void flushBrowser(String browserAddress, IBrowser browser, boolean dump) {
        this.sendOSC(browserAddress + "isActive", browser.isActive(), dump);
        this.sendOSC(browserAddress + "tab", browser.getSelectedContentType(), dump);
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            String filterAddress = browserAddress + "filter/" + (i + 1) + "/";
            IBrowserColumn column = browser.getFilterColumn(i);
            this.sendOSC(filterAddress + "exists", column.doesExist(), dump);
            this.sendOSC(filterAddress + "name", column.getName(), dump);
            this.sendOSC(filterAddress + "wildcard", column.getWildcard(), dump);
            IBrowserColumnItem[] items = column.getItems();
            for (int j = 0; j < items.length; ++j) {
                this.sendOSC(filterAddress + "item/" + (j + 1) + "/exists", items[j].doesExist(), dump);
                this.sendOSC(filterAddress + "item/" + (j + 1) + "/name", items[j].getName(), dump);
                this.sendOSC(filterAddress + "item/" + (j + 1) + "/hits", items[j].getHitCount(), dump);
                this.sendOSC(filterAddress + "item/" + (j + 1) + "/isSelected", items[j].isSelected(), dump);
            }
        }
        String presetAddress = browserAddress + "result/";
        IBrowserColumnItem[] items = browser.getResultColumnItems();
        for (int i = 0; i < items.length; ++i) {
            this.sendOSC(presetAddress + (i + 1) + "/exists", items[i].doesExist(), dump);
            this.sendOSC(presetAddress + (i + 1) + "/name", items[i].getName(), dump);
            this.sendOSC(presetAddress + (i + 1) + "/hits", items[i].getHitCount(), dump);
            this.sendOSC(presetAddress + (i + 1) + "/isSelected", items[i].isSelected(), dump);
        }
    }

    private void flushDeviceLayers(String deviceAddress, IChannel channel, boolean dump) {
        if (channel == null) {
            return;
        }
        this.sendOSC(deviceAddress + "exists", channel.doesExist(), dump);
        this.sendOSC(deviceAddress + "activated", channel.isActivated(), dump);
        this.sendOSC(deviceAddress + "selected", channel.isSelected(), dump);
        this.sendOSC(deviceAddress + "name", channel.getName(), dump);
        this.sendOSC(deviceAddress + "volumeStr", channel.getVolumeStr(), dump);
        this.sendOSC(deviceAddress + "volume", channel.getVolume(), dump);
        this.sendOSC(deviceAddress + "panStr", channel.getPanStr(), dump);
        this.sendOSC(deviceAddress + "pan", channel.getPan(), dump);
        this.sendOSC(deviceAddress + "mute", channel.isMute(), dump);
        this.sendOSC(deviceAddress + "solo", channel.isSolo(), dump);
        for (int i = 0; i < channel.getNumSends(); ++i) {
            this.flushParameterData(deviceAddress + "send/" + (i + 1) + "/", channel.getSend(i), dump);
        }
        if (((OSCConfiguration)this.configuration).isEnableVUMeters()) {
            this.sendOSC(deviceAddress + "vu", channel.getVu(), dump);
        }
        double[] color = channel.getColor();
        this.sendOSCColor(deviceAddress + "color", color[0], color[1], color[2], dump);
    }

    private void flushParameterData(String fxAddress, IParameter fxParam, boolean dump) {
        boolean isSend = fxParam instanceof ISend;
        this.sendOSC(fxAddress + "name", fxParam.getName(), dump);
        this.sendOSC(fxAddress + (isSend ? "volumeStr" : "valueStr"), fxParam.getDisplayedValue(), dump);
        this.sendOSC(fxAddress + (isSend ? "volume" : "value"), fxParam.getValue(), dump);
        this.sendOSC(fxAddress + "modulatedValue", fxParam.getModulatedValue(), dump);
    }

    private void flushNotes(String noteAddress, boolean dump) {
        for (int i = 0; i < 127; ++i) {
            double[] color = this.getNoteColor(i);
            this.sendOSCColor(noteAddress + i + "/color", color[0], color[1], color[2], dump);
        }
    }

    private double[] getNoteColor(int note) {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        if (!isKeyboardEnabled) {
            return OSCColors.getColor("SCALE_COLOR_OFF");
        }
        if (!this.keyManager.isKeyPressed(note)) {
            Scales scales = this.model.getScales();
            String color = scales.getColor(this.keyManager.getKeyTranslationMatrix(), note);
            return OSCColors.getColor(color);
        }
        boolean isRecording = this.model.hasRecordingState();
        return isRecording ? OSCColors.COLOR_RED : OSCColors.COLOR_GREEN;
    }
}

