/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.protocol;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.protocol.KeyManager;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlParser;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OSCParser
extends AbstractOpenSoundControlParser {
    private static final String PART_INDICATE = "indicate";
    private static final String PART_VOLUME = "volume";
    private static final String PART_RESET = "reset";
    private static final String PART_TOUCH = "touched";
    private static final Pattern RGB_COLOR_PATTERN = Pattern.compile("(rgb|RGB)\\((\\d+(\\.\\d+)?),(\\d+(\\.\\d+)?),(\\d+(\\.\\d+)?)\\)");
    private final Display display;
    private final KeyManager keyManager;

    public OSCParser(IHost host, IModel model, IOpenSoundControlConfiguration configuration, IOpenSoundControlWriter writer, IMidiInput midiInput, KeyManager keyManager) {
        super(host, model, midiInput, configuration, writer);
        this.keyManager = keyManager;
        this.display = new DummyDisplay(host);
        this.model.getCurrentTrackBank().setIndication(true);
        this.keyManager.updateNoteMapping();
    }

    @Override
    public void handle(IOpenSoundControlMessage message) {
        this.logMessage(message);
        LinkedList<String> oscParts = OSCParser.parseAddress(message);
        if (oscParts.isEmpty()) {
            return;
        }
        Object[] values = message.getValues();
        Object value = values == null || values.length == 0 ? null : values[0];
        int numValue = value == null || !(value instanceof Number) ? -1 : ((Number)value).intValue();
        String command = oscParts.removeFirst();
        if (this.parseTransportCommands(command, oscParts, value, numValue)) {
            return;
        }
        if (this.parseGlobalCommands(command)) {
            return;
        }
        if (this.parsePanelCommands(command, oscParts, value == null ? null : value.toString())) {
            return;
        }
        block13 : switch (command) {
            case "project": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Project subcommand.");
                    return;
                }
                switch (subCommand = oscParts.get(0)) {
                    case "+": {
                        this.model.getProject().next();
                        break block13;
                    }
                    case "-": {
                        this.model.getProject().previous();
                        break block13;
                    }
                    case "engine": {
                        if (numValue >= 0) {
                            this.model.getApplication().setEngineActive(numValue > 0);
                            break block13;
                        }
                        this.model.getApplication().toggleEngineActive();
                        break block13;
                    }
                }
                this.host.error("Unknown Project subcommand: " + subCommand);
                break;
            }
            case "scene": {
                String p;
                block40 : switch (p = oscParts.removeFirst()) {
                    case "bank": {
                        String subCommand2;
                        if (oscParts.isEmpty()) {
                            this.host.error("Missing Scene subcommand.");
                            return;
                        }
                        switch (subCommand2 = oscParts.get(0)) {
                            case "+": {
                                if (value != null && numValue <= 0) break block13;
                                this.model.getCurrentTrackBank().scrollScenesPageDown();
                                break;
                            }
                            case "-": {
                                if (value != null && numValue <= 0) break block13;
                                this.model.getCurrentTrackBank().scrollScenesPageUp();
                                break;
                            }
                            default: {
                                this.host.error("Unknown Scene subcommand: " + subCommand2);
                                break;
                            }
                        }
                        break block13;
                    }
                    case "+": {
                        if (value != null && numValue <= 0) break block13;
                        this.model.getCurrentTrackBank().scrollScenesDown();
                        break;
                    }
                    case "-": {
                        if (value != null && numValue <= 0) break block13;
                        this.model.getCurrentTrackBank().scrollScenesUp();
                        break;
                    }
                    case "create": {
                        this.model.getProject().createSceneFromPlayingLauncherClips();
                        break;
                    }
                    default: {
                        String sceneCommand;
                        if (oscParts.isEmpty()) {
                            this.host.error("Missing Scene index.");
                            return;
                        }
                        int scene = Integer.parseInt(p);
                        switch (sceneCommand = oscParts.removeFirst()) {
                            case "launch": {
                                this.model.getCurrentTrackBank().launchScene(scene - 1);
                                break block40;
                            }
                        }
                        this.host.error("Unknown Scene subcommand: " + sceneCommand);
                        break;
                    }
                }
                break;
            }
            case "track": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Track index or command.");
                    return;
                }
                try {
                    int trackNo = Integer.parseInt(oscParts.get(0));
                    oscParts.removeFirst();
                    this.parseTrackValue(this.model.getCurrentTrackBank().getTrack(trackNo - 1), oscParts, value);
                }
                catch (NumberFormatException ex) {
                    this.parseTrackCommands(oscParts, value, numValue);
                }
                break;
            }
            case "master": {
                this.parseTrackValue(this.masterTrack, oscParts, value);
                break;
            }
            case "device": {
                ICursorDevice cd = this.model.getCursorDevice();
                this.parseDeviceValue(cd, oscParts, value);
                break;
            }
            case "primary": {
                this.parseDeviceValue(this.model.getPrimaryDevice(), oscParts, value);
                break;
            }
            case "browser": {
                this.parseBrowser(oscParts);
                break;
            }
            case "vkb_midi": {
                this.parseMidi(oscParts, value);
                break;
            }
            case "action": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Action command ID.");
                    return;
                }
                String cmd = oscParts.get(0).replace('-', ' ');
                try {
                    this.model.getApplication().invokeAction(cmd);
                }
                catch (RuntimeException ex) {
                    this.host.error("Could not execute action: " + cmd);
                }
                break;
            }
            default: {
                this.host.println("Unknown OSC Command: " + message.getAddress() + " " + value);
            }
        }
    }

    private boolean parseTransportCommands(String command, LinkedList<String> oscParts, Object value, int numValue) {
        switch (command) {
            case "play": {
                if (value == null || numValue > 0 && !this.transport.isPlaying()) {
                    this.transport.play();
                }
                return true;
            }
            case "stop": {
                if (value == null || numValue > 0 && this.transport.isPlaying()) {
                    this.transport.play();
                }
                return true;
            }
            case "restart": {
                if (value == null || numValue > 0) {
                    this.transport.restart();
                }
                return true;
            }
            case "record": {
                if (value == null || numValue > 0) {
                    this.transport.record();
                }
                return true;
            }
            case "overdub": {
                if (value != null && numValue == 0) {
                    return true;
                }
                if (!oscParts.isEmpty() && "launcher".equals(oscParts.get(0))) {
                    this.transport.toggleLauncherOverdub();
                } else {
                    this.transport.toggleOverdub();
                }
                return true;
            }
            case "repeat": {
                if (value == null) {
                    this.transport.toggleLoop();
                } else {
                    this.transport.setLoop(numValue > 0);
                }
                return true;
            }
            case "punchIn": {
                if (value == null) {
                    this.transport.togglePunchIn();
                } else {
                    this.transport.setPunchIn(numValue > 0);
                }
                return true;
            }
            case "punchOut": {
                if (value == null) {
                    this.transport.togglePunchOut();
                } else {
                    this.transport.setPunchOut(numValue > 0);
                }
                return true;
            }
            case "click": {
                String cmd;
                if (oscParts.isEmpty()) {
                    if (value == null) {
                        this.transport.toggleMetronome();
                    } else {
                        this.transport.setMetronome(numValue > 0);
                    }
                    return true;
                }
                switch (cmd = oscParts.get(0)) {
                    case "volume": {
                        this.transport.setMetronomeVolume(numValue);
                        break;
                    }
                    case "ticks": {
                        if (value != null && numValue <= 0) break;
                        this.transport.toggleMetronomeTicks();
                        break;
                    }
                    case "preroll": {
                        if (value != null && numValue <= 0) break;
                        this.transport.togglePrerollMetronome();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Click subcommand: " + cmd);
                    }
                }
                return true;
            }
            case "quantize": {
                this.clip.quantize(1.0);
                return true;
            }
            case "tempo": {
                String tempoCommand;
                switch (tempoCommand = oscParts.get(0)) {
                    case "raw": {
                        if (value instanceof Number) {
                            this.transport.setTempo(((Number)value).doubleValue());
                        }
                        return true;
                    }
                    case "tap": {
                        if (value == null || numValue > 0) {
                            this.transport.tapTempo();
                        }
                        return true;
                    }
                    case "+": {
                        if (value == null || numValue > 0) {
                            double v;
                            double d = v = value == null ? 1.0 : ((Number)value).doubleValue();
                            if (value instanceof Number) {
                                this.transport.setTempo(this.transport.getTempo() + v);
                            }
                        }
                        return true;
                    }
                    case "-": {
                        if (value == null || numValue > 0) {
                            double v2;
                            double d = v2 = value == null ? 1.0 : ((Number)value).doubleValue();
                            if (value instanceof Number) {
                                this.transport.setTempo(this.transport.getTempo() - v2);
                            }
                        }
                        return true;
                    }
                }
                this.host.error("Unknown Tempo subcommand: " + tempoCommand);
                return true;
            }
            case "time": {
                if (value instanceof Number) {
                    this.transport.setPosition(((Number)value).doubleValue());
                }
                return true;
            }
            case "position": {
                String positionCommand;
                if (oscParts.isEmpty()) {
                    if (value != null) {
                        this.transport.changePosition(numValue >= 0, Math.abs(numValue) <= 1);
                    }
                    return true;
                }
                switch (positionCommand = oscParts.get(0)) {
                    case "+": {
                        this.transport.changePosition(true, true);
                        return true;
                    }
                    case "-": {
                        this.transport.changePosition(false, true);
                        return true;
                    }
                    case "++": {
                        this.transport.changePosition(true, false);
                        return true;
                    }
                    case "--": {
                        this.transport.changePosition(false, false);
                        return true;
                    }
                    case "start": {
                        this.transport.setPosition(0.0);
                        return true;
                    }
                }
                this.host.error("Unknown Position subcommand: " + positionCommand);
                return true;
            }
            case "crossfade": {
                if (numValue >= 0) {
                    this.transport.setCrossfade(numValue);
                }
                return true;
            }
            case "autowrite": {
                if (value != null && numValue == 0) {
                    return true;
                }
                if (!oscParts.isEmpty() && "launcher".equals(oscParts.get(0))) {
                    this.transport.toggleWriteClipLauncherAutomation();
                } else {
                    this.transport.toggleWriteArrangerAutomation();
                }
                return true;
            }
            case "automationWriteMode": {
                if (value != null) {
                    this.transport.setAutomationWriteMode(value.toString());
                }
                return true;
            }
            case "preroll": {
                this.transport.setPrerollAsBars(numValue);
                return true;
            }
        }
        return false;
    }

    private boolean parseGlobalCommands(String command) {
        switch (command) {
            case "refresh": {
                this.writer.flush(true);
                return true;
            }
            case "undo": {
                this.model.getApplication().undo();
                return true;
            }
            case "redo": {
                this.model.getApplication().redo();
                return true;
            }
        }
        return false;
    }

    private boolean parsePanelCommands(String command, LinkedList<String> oscParts, String value) {
        switch (command) {
            case "layout": {
                if (value != null) {
                    this.model.getApplication().setPanelLayout(value.toUpperCase());
                }
                return true;
            }
            case "panel": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Panel subcommand.");
                    return true;
                }
                IApplication app = this.model.getApplication();
                switch (subCommand = oscParts.get(0)) {
                    case "noteEditor": {
                        app.toggleNoteEditor();
                        break;
                    }
                    case "automationEditor": {
                        app.toggleAutomationEditor();
                        break;
                    }
                    case "devices": {
                        app.toggleDevices();
                        break;
                    }
                    case "mixer": {
                        app.toggleMixer();
                        break;
                    }
                    case "fullscreen": {
                        app.toggleFullScreen();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Panel subcommand: " + subCommand);
                    }
                }
                return true;
            }
            case "arranger": {
                String subCommand2;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Arranger subcommand.");
                    return true;
                }
                IArranger arrange = this.model.getArranger();
                switch (subCommand2 = oscParts.get(0)) {
                    case "cueMarkerVisibility": {
                        arrange.toggleCueMarkerVisibility();
                        break;
                    }
                    case "playbackFollow": {
                        arrange.togglePlaybackFollow();
                        break;
                    }
                    case "trackRowHeight": {
                        arrange.toggleTrackRowHeight();
                        break;
                    }
                    case "clipLauncherSectionVisibility": {
                        arrange.toggleClipLauncher();
                        break;
                    }
                    case "timeLineVisibility": {
                        arrange.toggleTimeLine();
                        break;
                    }
                    case "ioSectionVisibility": {
                        arrange.toggleIoSection();
                        break;
                    }
                    case "effectTracksVisibility": {
                        arrange.toggleEffectTracks();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Arranger subcommand: " + subCommand2);
                    }
                }
                return true;
            }
            case "mixer": {
                String subCommand3;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Mixer subcommand.");
                    return true;
                }
                IMixer mix = this.model.getMixer();
                switch (subCommand3 = oscParts.get(0)) {
                    case "clipLauncherSectionVisibility": {
                        mix.toggleClipLauncherSectionVisibility();
                        break;
                    }
                    case "crossFadeSectionVisibility": {
                        mix.toggleCrossFadeSectionVisibility();
                        break;
                    }
                    case "deviceSectionVisibility": {
                        mix.toggleDeviceSectionVisibility();
                        break;
                    }
                    case "sendsSectionVisibility": {
                        mix.toggleSendsSectionVisibility();
                        break;
                    }
                    case "ioSectionVisibility": {
                        mix.toggleIoSectionVisibility();
                        break;
                    }
                    case "meterSectionVisibility": {
                        mix.toggleMeterSectionVisibility();
                        break;
                    }
                    default: {
                        this.host.error("Unknown Mixer subcommand: " + subCommand3);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void parseTrackCommands(LinkedList<String> oscParts, Object value, int numValue) {
        String command;
        if (oscParts.isEmpty()) {
            this.host.error("Missing Track command.");
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        block12 : switch (command = oscParts.removeFirst()) {
            case "indicate": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Indicate subcommand.");
                    return;
                }
                boolean isTrue = numValue > 0;
                switch (subCommand = oscParts.removeFirst()) {
                    case "volume": {
                        for (int i = 0; i < tb.getNumTracks(); ++i) {
                            tb.getTrack(i).setVolumeIndication(isTrue);
                        }
                        break block12;
                    }
                    case "pan": {
                        for (int i = 0; i < tb.getNumTracks(); ++i) {
                            tb.getTrack(i).setPanIndication(isTrue);
                        }
                        break block12;
                    }
                    case "send": {
                        if (!(tb instanceof ITrackBank)) break block12;
                        int sendIndex = Integer.parseInt(oscParts.get(0));
                        for (int i = 0; i < tb.getNumTracks(); ++i) {
                            tb.getTrack(i).getSend(sendIndex - 1).setIndication(isTrue);
                        }
                        break block12;
                    }
                    default: {
                        this.host.error("Unknown Indicate subcommand: " + subCommand);
                        break;
                    }
                }
                break;
            }
            case "bank": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Track Bank subcommand.");
                    return;
                }
                switch (subCommand = oscParts.removeFirst()) {
                    case "page": {
                        if (oscParts.isEmpty()) {
                            this.host.error("Missing Track Bank Page subcommand.");
                            return;
                        }
                        if ("+".equals(oscParts.removeFirst())) {
                            if (!tb.canScrollTracksDown()) {
                                return;
                            }
                            tb.scrollTracksPageDown();
                            this.host.scheduleTask(() -> tb.getTrack(0).selectAndMakeVisible(), 75L);
                            break block12;
                        }
                        if (!tb.canScrollTracksUp()) {
                            return;
                        }
                        tb.scrollTracksPageUp();
                        this.host.scheduleTask(() -> tb.getTrack(7).selectAndMakeVisible(), 75L);
                        break block12;
                    }
                    case "+": {
                        tb.scrollTracksDown();
                        break block12;
                    }
                    case "-": {
                        tb.scrollTracksUp();
                        break block12;
                    }
                }
                this.host.error("Unknown Track Bank subcommand: " + subCommand);
                break;
            }
            case "+": {
                int index;
                ITrack sel = tb.getSelectedTrack();
                int n = index = sel == null ? 0 : sel.getIndex() + 1;
                if (index == tb.getNumTracks()) {
                    if (!tb.canScrollTracksDown()) {
                        return;
                    }
                    tb.scrollTracksPageDown();
                    this.host.scheduleTask(() -> tb.getTrack(0).selectAndMakeVisible(), 75L);
                    return;
                }
                tb.getTrack(index).selectAndMakeVisible();
                break;
            }
            case "-": {
                int index;
                ITrack sel = tb.getSelectedTrack();
                int n = index = sel == null ? 0 : sel.getIndex() - 1;
                if (index == -1) {
                    if (!tb.canScrollTracksUp()) {
                        return;
                    }
                    tb.scrollTracksPageUp();
                    this.host.scheduleTask(() -> tb.getTrack(7).selectAndMakeVisible(), 75L);
                    return;
                }
                tb.getTrack(index).selectAndMakeVisible();
                break;
            }
            case "add": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Add subcommand.");
                    return;
                }
                String subCommand2 = oscParts.removeFirst();
                IApplication application = this.model.getApplication();
                switch (subCommand2) {
                    case "audio": {
                        application.addAudioTrack();
                        break block12;
                    }
                    case "effect": {
                        application.addEffectTrack();
                        break block12;
                    }
                    case "instrument": {
                        application.addInstrumentTrack();
                        break block12;
                    }
                }
                this.host.error("Unknown Add subcommand: " + subCommand2);
                break;
            }
            case "stop": {
                this.model.getCurrentTrackBank().stop();
                break;
            }
            case "vu": {
                ((OSCConfiguration)this.configuration).setVUMetersEnabled(numValue > 0);
                break;
            }
            case "toggleBank": {
                if (this.model.getEffectTrackBank() == null) {
                    return;
                }
                this.model.toggleCurrentTrackBank();
                IChannelBank tbNew = this.model.getCurrentTrackBank();
                IChannelBank tbOther = this.model.isEffectTrackBankActive() ? this.model.getTrackBank() : this.model.getEffectTrackBank();
                ITrack selectedTrack = tbNew.getSelectedTrack();
                if (selectedTrack == null) {
                    tbNew.getTrack(0).selectAndMakeVisible();
                }
                for (int i = 0; i < tbNew.getNumTracks(); ++i) {
                    ITrack otherTrack = tbOther.getTrack(i);
                    otherTrack.setVolumeIndication(false);
                    otherTrack.setPanIndication(false);
                    ITrack track = tbNew.getTrack(i);
                    track.setVolumeIndication(true);
                    track.setPanIndication(true);
                }
                break;
            }
            case "parent": {
                if (!(tb instanceof ITrackBank)) break;
                ((ITrackBank)tb).selectParent();
                break;
            }
            case "selected": {
                ITrack selectedTrack = tb.getSelectedTrack();
                if (selectedTrack == null) break;
                this.parseTrackValue(selectedTrack, oscParts, value);
                break;
            }
            default: {
                this.host.println("Unknown Track Command: " + command);
            }
        }
    }

    private void parseTrackValue(ITrack track, LinkedList<String> parts, Object value) {
        String command;
        int intValue;
        double numValue = value instanceof Number ? ((Number)value).doubleValue() : -1.0;
        int n = intValue = value instanceof Number ? ((Number)value).intValue() : -1;
        if (parts.isEmpty()) {
            this.host.error("Missing Track command.");
            return;
        }
        block17 : switch (command = parts.removeFirst()) {
            case "activated": {
                track.setIsActivated(intValue > 0);
                break;
            }
            case "crossfadeMode": {
                if (numValue != 1.0) break;
                track.setCrossfadeMode(parts.removeFirst());
                break;
            }
            case "selected": {
                if (intValue <= 0) break;
                track.selectAndMakeVisible();
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    track.setVolume(numValue);
                    break;
                }
                if (PART_INDICATE.equals(parts.get(0))) {
                    track.setVolumeIndication(numValue > 0.0);
                    break;
                }
                if (PART_RESET.equals(parts.get(0))) {
                    track.resetVolume();
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                track.touchVolume(numValue > 0.0);
                break;
            }
            case "pan": {
                if (parts.isEmpty()) {
                    track.setPan(numValue);
                    break;
                }
                if (PART_INDICATE.equals(parts.get(0))) {
                    track.setPanIndication(numValue > 0.0);
                    break;
                }
                if (PART_RESET.equals(parts.get(0))) {
                    track.resetPan();
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                track.touchPan(numValue > 0.0);
                break;
            }
            case "mute": {
                if (numValue < 0.0) {
                    track.toggleMute();
                    break;
                }
                track.setMute(numValue > 0.0);
                break;
            }
            case "solo": {
                if (numValue < 0.0) {
                    track.toggleSolo();
                    break;
                }
                track.setSolo(numValue > 0.0);
                break;
            }
            case "recarm": {
                if (numValue < 0.0) {
                    track.toggleRecArm();
                    break;
                }
                track.setRecArm(numValue > 0.0);
                break;
            }
            case "monitor": {
                if (numValue < 0.0) {
                    track.toggleMonitor();
                    break;
                }
                track.setMonitor(numValue > 0.0);
                break;
            }
            case "autoMonitor": {
                if (numValue < 0.0) {
                    track.toggleAutoMonitor();
                    break;
                }
                track.setAutoMonitor(numValue > 0.0);
                break;
            }
            case "send": {
                int sendNo = Integer.parseInt(parts.removeFirst());
                this.parseSendValue(track, sendNo - 1, parts, value);
                break;
            }
            case "clip": {
                if (parts.isEmpty()) {
                    this.host.error("Missing Clip subcommand.");
                    return;
                }
                String cmd = parts.removeFirst();
                try {
                    int clipNo = Integer.parseInt(cmd);
                    if (parts.isEmpty()) {
                        this.host.error("Missing Clip subcommand.");
                        return;
                    }
                    String clipCommand = parts.removeFirst();
                    ISlot slot = track.getSlot(clipNo - 1);
                    switch (clipCommand) {
                        case "select": {
                            slot.select();
                            break block17;
                        }
                        case "launch": {
                            slot.launch();
                            break block17;
                        }
                        case "record": {
                            slot.record();
                            break block17;
                        }
                        case "color": {
                            Matcher matcher = RGB_COLOR_PATTERN.matcher(value.toString());
                            if (!matcher.matches()) {
                                return;
                            }
                            int count = matcher.groupCount();
                            if (count != 7) {
                                return;
                            }
                            slot.setColor(Double.parseDouble(matcher.group(2)) / 255.0, Double.parseDouble(matcher.group(4)) / 255.0, Double.parseDouble(matcher.group(6)) / 255.0);
                            break block17;
                        }
                    }
                    this.host.println("Unknown Clip subcommand: " + clipCommand);
                }
                catch (NumberFormatException ex) {
                    switch (cmd) {
                        case "stop": {
                            track.stop();
                            break block17;
                        }
                        case "returntoarrangement": {
                            track.returnToArrangement();
                            break block17;
                        }
                    }
                    this.host.println("Unknown Clip command: " + cmd);
                }
                break;
            }
            case "enter": {
                IChannelBank tb = this.model.getCurrentTrackBank();
                if (!(tb instanceof ITrackBank)) break;
                track.select();
                ((ITrackBank)tb).selectChildren();
                break;
            }
            case "color": {
                Matcher matcher = RGB_COLOR_PATTERN.matcher(value.toString());
                if (!matcher.matches()) {
                    return;
                }
                int count = matcher.groupCount();
                if (count != 7) break;
                track.setColor(Double.parseDouble(matcher.group(2)) / 255.0, Double.parseDouble(matcher.group(4)) / 255.0, Double.parseDouble(matcher.group(6)) / 255.0);
                break;
            }
            default: {
                this.host.println("Unknown Track Parameter: " + command);
            }
        }
    }

    private void parseSendValue(ITrack track, int sendIndex, LinkedList<String> parts, Object value) {
        String command;
        if (parts.isEmpty()) {
            this.host.error("Missing Send subcommand.");
            return;
        }
        double numValue = value instanceof Number ? ((Number)value).doubleValue() : -1.0;
        switch (command = parts.removeFirst()) {
            case "volume": {
                ISend send = track.getSend(sendIndex);
                if (send == null) break;
                if (parts.isEmpty()) {
                    send.setValue(numValue);
                    break;
                }
                if (PART_INDICATE.equals(parts.get(0))) {
                    send.setIndication(numValue > 0.0);
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                send.touchValue(numValue > 0.0);
                break;
            }
            default: {
                this.host.println("Unknown Send Parameter value: " + command);
            }
        }
    }

    private void parseDeviceValue(ICursorDevice cursorDevice, LinkedList<String> oscParts, Object value) {
        String command;
        if (oscParts.isEmpty()) {
            this.host.error("Missing Device subcommand.");
            return;
        }
        int numValue = value instanceof Number ? ((Number)value).intValue() : -1;
        block15 : switch (command = oscParts.removeFirst()) {
            case "page": {
                String subCommand;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Device Page subcommand.");
                    return;
                }
                int bankNo = Integer.parseInt(oscParts.removeFirst());
                switch (subCommand = oscParts.removeFirst()) {
                    case "selected": {
                        if (numValue <= 0) break block15;
                        String[] parameterPageNames = cursorDevice.getParameterPageNames();
                        int selectedParameterPage = cursorDevice.getSelectedParameterPage();
                        int page = Math.min(Math.max(0, selectedParameterPage), parameterPageNames.length - 1);
                        int start = page / 8 * 8;
                        int bankPage = start + bankNo - 1;
                        if (bankPage >= parameterPageNames.length) break block15;
                        cursorDevice.setSelectedParameterPage(bankPage);
                        break;
                    }
                    default: {
                        this.host.println("Unknown Device Device Page Parameter: " + subCommand);
                        break;
                    }
                }
                break;
            }
            case "sibling": {
                String subCommand2;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Device Sibling subcommand.");
                    return;
                }
                int siblingNo = Integer.parseInt(oscParts.removeFirst());
                switch (subCommand2 = oscParts.removeFirst()) {
                    case "selected": {
                        if (numValue <= 0) break block15;
                        cursorDevice.selectSibling(siblingNo - 1);
                        break;
                    }
                    default: {
                        this.host.println("Unknown Device Device Sibling Parameter: " + subCommand2);
                        break;
                    }
                }
                break;
            }
            case "bank": {
                String subCommand3;
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Device Bank subcommand.");
                    return;
                }
                switch (subCommand3 = oscParts.removeFirst()) {
                    case "page": {
                        if (oscParts.isEmpty()) {
                            this.host.error("Missing Device Bank Page subcommand.");
                            return;
                        }
                        if ("+".equals(oscParts.removeFirst())) {
                            cursorDevice.selectNextBank();
                            this.host.scheduleTask(() -> cursorDevice.selectSibling(0), 75L);
                            break block15;
                        }
                        cursorDevice.selectPreviousBank();
                        this.host.scheduleTask(() -> cursorDevice.selectSibling(7), 75L);
                        break block15;
                    }
                }
                this.host.error("Unknown Device Bank subcommand: " + subCommand3);
                break;
            }
            case "expand": {
                cursorDevice.toggleExpanded();
                break;
            }
            case "bypass": {
                cursorDevice.toggleEnabledState();
                break;
            }
            case "window": {
                cursorDevice.toggleWindowOpen();
                break;
            }
            case "indicate": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Device Indicate subcommand.");
                    return;
                }
                switch (oscParts.removeFirst()) {
                    case "param": {
                        for (int i = 0; i < cursorDevice.getNumParameters(); ++i) {
                            cursorDevice.indicateParameter(i, numValue > 0);
                        }
                        break block15;
                    }
                    default: {
                        this.host.println("Unknown Device Indicate Parameter: " + command);
                        break;
                    }
                }
                break;
            }
            case "param": {
                if (oscParts.isEmpty()) {
                    this.host.error("Missing Device Param subcommand.");
                    return;
                }
                String part = oscParts.removeFirst();
                try {
                    int paramNo = Integer.parseInt(part);
                    this.parseFXParamValue(cursorDevice, paramNo - 1, oscParts, value);
                }
                catch (NumberFormatException ex) {
                    if (value != null && numValue <= 0) break;
                    switch (part) {
                        case "+": {
                            cursorDevice.nextParameterPage();
                            break block15;
                        }
                        case "-": {
                            cursorDevice.previousParameterPage();
                            break block15;
                        }
                        case "bank": {
                            String subCommand4;
                            if (oscParts.isEmpty()) {
                                this.host.error("Missing Device Param Bank subcommand.");
                                return;
                            }
                            switch (subCommand4 = oscParts.removeFirst()) {
                                case "page": {
                                    if (oscParts.isEmpty()) {
                                        this.host.error("Missing Device Param Bank Page subcommand.");
                                        return;
                                    }
                                    if ("+".equals(oscParts.removeFirst())) {
                                        cursorDevice.nextParameterPageBank();
                                        break block15;
                                    }
                                    cursorDevice.previousParameterPageBank();
                                    break block15;
                                }
                            }
                            this.host.error("Unknown Device Param Bank subcommand: " + subCommand4);
                            break block15;
                        }
                    }
                    this.host.println("Unknown Device Param Parameter: " + command);
                }
                break;
            }
            case "+": {
                if (value != null && numValue <= 0) break;
                cursorDevice.selectNext();
                break;
            }
            case "-": {
                if (value != null && numValue <= 0) break;
                cursorDevice.selectPrevious();
                break;
            }
            case "drumpad": {
                if (!cursorDevice.hasDrumPads()) break;
                this.parseLayerOrDrumpad(cursorDevice, oscParts, value);
                break;
            }
            case "layer": {
                this.parseLayerOrDrumpad(cursorDevice, oscParts, value);
                break;
            }
            default: {
                this.host.println("Unknown Device command: " + command);
            }
        }
    }

    private void parseLayerOrDrumpad(ICursorDevice cursorDevice, LinkedList<String> parts, Object value) {
        if (parts.isEmpty()) {
            this.host.println("Missing Layer/Drumpad command.");
            return;
        }
        String command = parts.removeFirst();
        try {
            IChannel selectedLayerOrDrumPad;
            int layerNo = "selected".equals(command) ? ((selectedLayerOrDrumPad = cursorDevice.getSelectedLayerOrDrumPad()) == null ? -1 : selectedLayerOrDrumPad.getIndex()) : Integer.parseInt(command) - 1;
            this.parseDeviceLayerValue(cursorDevice, layerNo, parts, value);
        }
        catch (NumberFormatException ex) {
            switch (command) {
                case "parent": {
                    if (!cursorDevice.doesExist()) break;
                    cursorDevice.selectParent();
                    cursorDevice.selectChannel();
                    break;
                }
                case "+": {
                    cursorDevice.nextLayerOrDrumPad();
                    break;
                }
                case "-": {
                    cursorDevice.previousLayerOrDrumPad();
                    break;
                }
                case "page": {
                    if (parts.isEmpty()) {
                        this.host.println("Missing Layer/Drumpad Page subcommand: " + command);
                        return;
                    }
                    if ("+".equals(parts.get(0))) {
                        cursorDevice.nextLayerOrDrumPadBank();
                        break;
                    }
                    cursorDevice.previousLayerOrDrumPadBank();
                    break;
                }
                default: {
                    this.host.println("Unknown Layour/Drum command: " + command);
                }
            }
        }
    }

    private void parseBrowser(LinkedList<String> parts) {
        String command;
        if (parts.isEmpty()) {
            this.host.println("Missing Browser command.");
            return;
        }
        IBrowser browser = this.model.getBrowser();
        switch (command = parts.removeFirst()) {
            case "preset": {
                browser.browseForPresets();
                break;
            }
            case "tab": {
                if (parts.isEmpty()) {
                    this.host.println("Missing Browser Tab subcommand.");
                    return;
                }
                if (!browser.isActive()) {
                    return;
                }
                String subCmd = parts.removeFirst();
                if ("+".equals(subCmd)) {
                    browser.nextContentType();
                    break;
                }
                if (!"-".equals(subCmd)) break;
                browser.previousContentType();
                break;
            }
            case "device": {
                String insertLocation;
                String string = insertLocation = parts.isEmpty() ? null : parts.removeFirst();
                if (insertLocation == null || "after".equals(insertLocation)) {
                    browser.browseToInsertAfterDevice();
                    break;
                }
                browser.browseToInsertBeforeDevice();
                break;
            }
            case "commit": {
                browser.stopBrowsing(true);
                break;
            }
            case "cancel": {
                browser.stopBrowsing(false);
                break;
            }
            case "filter": {
                if (parts.isEmpty()) {
                    this.host.println("Missing Browser Filter row.");
                    return;
                }
                int column = Integer.parseInt(parts.removeFirst());
                if (column < 1 || column > 6) {
                    return;
                }
                --column;
                if (!browser.isActive()) {
                    return;
                }
                if (parts.isEmpty()) {
                    this.host.println("Missing Browser Filter command.");
                    return;
                }
                String cmd = parts.removeFirst();
                if ("+".equals(cmd)) {
                    browser.selectNextFilterItem(column);
                    break;
                }
                if ("-".equals(cmd)) {
                    browser.selectPreviousFilterItem(column);
                    break;
                }
                if (!PART_RESET.equals(cmd)) break;
                browser.getFilterColumn(column).resetFilter();
                break;
            }
            case "result": {
                String direction;
                if (!browser.isActive()) {
                    return;
                }
                String string = direction = parts.isEmpty() ? "+" : parts.removeFirst();
                if ("+".equals(direction)) {
                    browser.selectNextResult();
                    break;
                }
                browser.selectPreviousResult();
                break;
            }
            default: {
                this.host.println("Unknown Browser Command: " + command);
            }
        }
    }

    private void parseDeviceLayerValue(ICursorDevice cursorDevice, int layer, LinkedList<String> parts, Object value) {
        if (parts.isEmpty()) {
            this.host.println("Missing Device Layer command.");
            return;
        }
        String command = parts.removeFirst();
        int numValue = value instanceof Number ? ((Number)value).intValue() : -1;
        switch (command) {
            case "select": {
                cursorDevice.selectLayer(layer);
                break;
            }
            case "volume": {
                if (parts.isEmpty()) {
                    cursorDevice.setLayerOrDrumPadVolume(layer, numValue);
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                cursorDevice.touchLayerOrDrumPadVolume(layer, numValue > 0);
                break;
            }
            case "pan": {
                if (parts.isEmpty()) {
                    cursorDevice.setLayerOrDrumPadPan(layer, numValue);
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                cursorDevice.touchLayerOrDrumPadPan(layer, numValue > 0);
                break;
            }
            case "mute": {
                if (numValue < 0) {
                    cursorDevice.toggleLayerOrDrumPadMute(layer);
                    break;
                }
                cursorDevice.setLayerOrDrumPadMute(layer, numValue > 0);
                break;
            }
            case "solo": {
                if (numValue < 0) {
                    cursorDevice.toggleLayerOrDrumPadSolo(layer);
                    break;
                }
                cursorDevice.setLayerOrDrumPadSolo(layer, numValue > 0);
                break;
            }
            case "send": {
                int sendNo = Integer.parseInt(parts.removeFirst()) - 1;
                if (parts.isEmpty()) {
                    cursorDevice.setLayerOrDrumPadSend(layer, sendNo, numValue);
                    break;
                }
                if (!PART_TOUCH.equals(parts.get(0))) break;
                cursorDevice.touchLayerOrDrumPadSend(layer, sendNo, numValue > 0);
                break;
            }
            case "enter": {
                cursorDevice.enterLayerOrDrumPad(layer);
                cursorDevice.selectFirstDeviceInLayerOrDrumPad(layer);
                break;
            }
            default: {
                this.host.println("Unknown Device Layer command: " + command);
            }
        }
    }

    private void parseFXParamValue(ICursorDevice cursorDevice, int fxparamIndex, LinkedList<String> parts, Object value) {
        String command;
        if (parts.isEmpty()) {
            this.host.println("Missing FX Parameter command.");
            return;
        }
        int numValue = value instanceof Number ? ((Number)value).intValue() : -1;
        switch (command = parts.get(0)) {
            case "value": {
                if (parts.size() != 1 || value == null) break;
                cursorDevice.setParameter(fxparamIndex, numValue);
                break;
            }
            case "indicate": {
                if (parts.size() != 1 || value == null) break;
                cursorDevice.indicateParameter(fxparamIndex, numValue > 0);
                break;
            }
            case "reset": {
                cursorDevice.resetParameter(fxparamIndex);
                break;
            }
            case "touched": {
                cursorDevice.touchParameter(fxparamIndex, numValue > 0);
                break;
            }
            default: {
                this.host.println("Unknown FX Parameter value:" + command);
            }
        }
    }

    private void parseMidi(LinkedList<String> parts, Object value) {
        String subCommand;
        int midiChannel;
        if (parts.isEmpty()) {
            this.host.println("Missing Midi command.");
            return;
        }
        int numValue = value instanceof Number ? ((Number)value).intValue() : -1;
        String command = parts.removeFirst();
        OSCConfiguration conf = (OSCConfiguration)this.configuration;
        try {
            midiChannel = Integer.parseInt(command);
        }
        catch (NumberFormatException ex) {
            switch (command) {
                case "velocity": {
                    conf.setAccentEnabled(numValue > 0);
                    if (numValue <= 0) break;
                    conf.setAccentValue(numValue);
                    break;
                }
                default: {
                    this.host.println("Unknown Midi command:" + command);
                }
            }
            return;
        }
        if (parts.isEmpty()) {
            this.host.println("Missing Midi subcommand.");
            return;
        }
        block14 : switch (subCommand = parts.removeFirst()) {
            case "note": {
                String n;
                if (parts.isEmpty()) {
                    this.host.println("Missing Midi Note subcommand.");
                    return;
                }
                switch (n = parts.removeFirst()) {
                    case "+": {
                        if (value != null && numValue <= 0) break block14;
                        this.scales.incOctave();
                        this.keyManager.updateNoteMapping();
                        this.display.notify(this.scales.getRangeText());
                        break;
                    }
                    case "-": {
                        if (value != null && numValue <= 0) break block14;
                        this.scales.decOctave();
                        this.keyManager.updateNoteMapping();
                        this.display.notify(this.scales.getRangeText());
                        break;
                    }
                    default: {
                        int data0;
                        int note = Integer.parseInt(n);
                        if (numValue > 0) {
                            int n2 = numValue = conf.isAccentActive() ? conf.getFixedAccentValue() : numValue;
                        }
                        if ((data0 = this.keyManager.getKeyTranslationMatrix()[note]) >= 0) {
                            this.midiInput.sendRawMidiEvent(144 + midiChannel, data0, numValue);
                        }
                        int[] keyTranslationMatrix = this.keyManager.getKeyTranslationMatrix();
                        for (int i = 0; i < 128; ++i) {
                            if (keyTranslationMatrix[note] != keyTranslationMatrix[i]) continue;
                            this.keyManager.setKeyPressed(i, numValue);
                        }
                        break block14;
                    }
                }
                break;
            }
            case "drum": {
                String n;
                if (parts.isEmpty()) {
                    this.host.println("Missing Midi Drum subcommand.");
                    return;
                }
                switch (n = parts.removeFirst()) {
                    case "+": {
                        if (numValue == 0) break block14;
                        this.scales.incDrumOctave();
                        this.keyManager.updateNoteMapping();
                        this.display.notify(this.scales.getDrumRangeText());
                        break;
                    }
                    case "-": {
                        if (numValue == 0) break block14;
                        this.scales.decDrumOctave();
                        this.keyManager.updateNoteMapping();
                        this.display.notify(this.scales.getDrumRangeText());
                        break;
                    }
                    default: {
                        int data0;
                        int note = Integer.parseInt(n);
                        if (numValue > 0) {
                            int n3 = numValue = conf.isAccentActive() ? conf.getFixedAccentValue() : numValue;
                        }
                        if ((data0 = this.keyManager.getDrumTranslationMatrix()[note]) < 0) break block14;
                        this.midiInput.sendRawMidiEvent(144 + midiChannel, data0, numValue);
                        break;
                    }
                }
                break;
            }
            case "cc": {
                if (parts.isEmpty()) {
                    this.host.println("Missing Midi CC value.");
                    return;
                }
                int cc = Integer.parseInt(parts.removeFirst());
                this.midiInput.sendRawMidiEvent(176 + midiChannel, cc, numValue);
                break;
            }
            case "aftertouch": {
                if (numValue > 0) {
                    int n = numValue = conf.isAccentActive() ? conf.getFixedAccentValue() : numValue;
                }
                if (parts.isEmpty()) {
                    this.midiInput.sendRawMidiEvent(208 + midiChannel, 0, numValue);
                    return;
                }
                int note = Integer.parseInt(parts.removeFirst());
                this.midiInput.sendRawMidiEvent(160 + midiChannel, this.keyManager.getKeyTranslationMatrix()[note], numValue);
                break;
            }
            case "pitchbend": {
                this.midiInput.sendRawMidiEvent(224 + midiChannel, 0, numValue);
                break;
            }
            default: {
                this.host.println("Unknown Midi Parameter:" + subCommand);
            }
        }
    }

    private static LinkedList<String> parseAddress(IOpenSoundControlMessage message) {
        LinkedList<String> oscParts = new LinkedList<String>();
        Collections.addAll(oscParts, message.getAddress().split("/"));
        oscParts.removeFirst();
        return oscParts;
    }
}

