/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.protocol;

import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.NoteObserver;
import de.mossgrabers.framework.scale.Scales;
import java.util.Arrays;

public class KeyManager
implements NoteObserver {
    private final Scales scales;
    private final int[] pressedKeys = new int[128];
    private int[] keysTranslation = null;
    private int[] drumsTranslation = null;

    public KeyManager(IModel model) {
        this.scales = model.getScales();
        Arrays.fill(this.pressedKeys, 0);
        this.updateNoteMapping();
    }

    public void updateNoteMapping() {
        this.drumsTranslation = this.scales.getDrumMatrix();
        this.keysTranslation = this.scales.getNoteMatrix();
    }

    public void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    public boolean isKeyPressed(int key) {
        return this.pressedKeys[key] > 0;
    }

    public void setKeyPressed(int key, int velocity) {
        this.pressedKeys[key] = velocity;
    }

    public int[] getKeyTranslationMatrix() {
        return this.keysTranslation;
    }

    public int[] getDrumTranslationMatrix() {
        return this.drumsTranslation;
    }

    @Override
    public void call(int note, int velocity) {
        for (int i = 0; i < 128; ++i) {
            if (this.keysTranslation[i] != note) continue;
            this.pressedKeys[i] = velocity;
        }
    }
}

