/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.protocol.KeyManager;
import de.mossgrabers.controller.osc.protocol.OSCParser;
import de.mossgrabers.controller.osc.protocol.OSCWriter;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.DefaultValueChanger;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.osc.IOpenSoundControlConfiguration;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.scale.Scales;

public class OSCControllerSetup
extends AbstractControllerSetup<IControlSurface<OSCConfiguration>, OSCConfiguration> {
    private OSCWriter writer;
    private KeyManager keyManager;

    public OSCControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings) {
        super(factory, host, settings);
        this.colorManager = new ColorManager();
        this.valueChanger = new DefaultValueChanger(128, 1, 0.5);
        this.configuration = new OSCConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.writer.flush(false);
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 0, 128, 128, 1);
        this.scales.setChromatic(true);
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8, 8, 8, 16, 16, false, 8, 8, 8, 16);
        this.keyManager = new KeyManager(this.model);
        ITrackBank tb = this.model.getTrackBank();
        tb.addNoteObserver(this.keyManager);
        tb.addTrackSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiInput midiInput = midiAccess.createInput("OSC", new String[0]);
        IOpenSoundControlServer oscServer = this.host.connectToOSCServer(((OSCConfiguration)this.configuration).getSendHost(), ((OSCConfiguration)this.configuration).getSendPort());
        this.writer = new OSCWriter(this.host, this.model, oscServer, this.keyManager, (OSCConfiguration)this.configuration);
        this.host.createOSCServer(new OSCParser(this.host, this.model, (IOpenSoundControlConfiguration)((Object)this.configuration), this.writer, midiInput, this.keyManager), ((OSCConfiguration)this.configuration).getReceivePort());
    }

    @Override
    public void startup() {
        this.host.scheduleTask(() -> this.writer.flush(true), 1000L);
    }
}

