/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc;

import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.IValueChanger;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlConfiguration;

public class OSCConfiguration
extends AbstractOpenSoundControlConfiguration {
    public static final Integer RECEIVE_PORT = 50;
    public static final Integer SEND_HOST = 51;
    public static final Integer SEND_PORT = 52;
    private int receivePort = 8000;
    private String sendHost = "127.0.0.1";
    private int sendPort = 9000;

    public OSCConfiguration(IValueChanger valueChanger) {
        super(valueChanger);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        IIntegerSetting receivePortSetting = settingsUI.getRangeSetting("Port", "Receive from (Script restart required)", 0, 65535, 1, "", 8000);
        receivePortSetting.addValueObserver(value -> {
            this.receivePort = value;
            this.notifyObservers(RECEIVE_PORT);
        });
        receivePortSetting.setEnabled(false);
        IStringSetting sendHostSetting = settingsUI.getStringSetting("Host", "Send to", 15, "127.0.0.1");
        sendHostSetting.addValueObserver(value -> {
            this.sendHost = value;
            this.notifyObservers(SEND_HOST);
        });
        sendHostSetting.setEnabled(false);
        IIntegerSetting sendPortSetting = settingsUI.getRangeSetting("Port", "Send to", 0, 65535, 1, "", 9000);
        sendPortSetting.addValueObserver(value -> {
            this.sendPort = value;
            this.notifyObservers(SEND_PORT);
        });
        sendPortSetting.setEnabled(false);
        this.activateAccentActiveSetting(settingsUI);
        this.activateAccentValueSetting(settingsUI);
        this.activateEnableVUMetersSetting(settingsUI);
        this.activateOSCLogging(settingsUI);
    }

    public int getReceivePort() {
        return this.receivePort;
    }

    public String getSendHost() {
        return this.sendHost;
    }

    public int getSendPort() {
        return this.sendPort;
    }
}

