/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.track;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.StringUtils;

public class TrackMode
extends AbstractTrackMode {
    public TrackMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        boolean effectTrackBankActive = this.model.isEffectTrackBankActive();
        switch (index) {
            case 0: {
                selectedTrack.changeVolume(value);
                return;
            }
            case 1: {
                selectedTrack.changePan(value);
                return;
            }
        }
        MCUConfiguration config = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        if (index == 2) {
            if (config.isDisplayCrossfader()) {
                selectedTrack.changeCrossfadeModeAsNumber(value);
            } else if (!effectTrackBankActive) {
                selectedTrack.getSend(0).changeValue(value);
            }
        } else if (!effectTrackBankActive) {
            selectedTrack.getSend(index - (config.isDisplayCrossfader() ? 3 : 2)).changeValue(value);
        }
    }

    @Override
    public void updateDisplay() {
        if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            return;
        }
        this.drawDisplay2();
        if (!this.drawTrackHeader()) {
            return;
        }
        Display d = ((MCUControlSurface)this.surface).getDisplay().clear();
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack == null) {
            d.notify("Please select a track...", true, false);
            return;
        }
        MCUConfiguration config = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        boolean displayTrackNames = ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayTrackNames();
        if (!displayTrackNames) {
            d.setCell(0, 0, "Volume");
            d.setCell(0, 1, "Pan");
        }
        d.setCell(1, 0, selectedTrack.getVolumeStr(6));
        d.setCell(1, 1, selectedTrack.getPanStr(6));
        int sendStart = 2;
        int sendCount = 6;
        if (config.isDisplayCrossfader()) {
            sendStart = 3;
            sendCount = 5;
            String crossfadeMode = selectedTrack.getCrossfadeMode();
            if (!displayTrackNames) {
                d.setCell(0, 2, "Crossfade");
            }
            d.setCell(1, 2, "A".equals(crossfadeMode) ? "A" : ("B".equals(crossfadeMode) ? "     B" : "  <>  "));
        }
        boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
        for (int i = 0; i < sendCount; ++i) {
            ISend send;
            int pos = sendStart + i;
            if (isEffectTrackBankActive || !(send = selectedTrack.getSend(i)).doesExist()) continue;
            if (!displayTrackNames) {
                d.setCell(0, pos, StringUtils.fixASCII(send.getName()));
            }
            d.setCell(1, pos, send.getDisplayedValue(6));
        }
        if (!displayTrackNames) {
            d.done(0);
        }
        d.done(1);
    }

    @Override
    protected void updateKnobLEDs() {
        int end;
        int upperBound = this.model.getValueChanger().getUpperBound();
        ITrack t = this.model.getSelectedTrack();
        if (t == null) {
            for (int i = 0; i < 8; ++i) {
                ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, upperBound);
            }
            return;
        }
        ((MCUControlSurface)this.surface).setKnobLED(0, 2, t.getVolume(), upperBound);
        ((MCUControlSurface)this.surface).setKnobLED(1, 1, t.getPan(), upperBound);
        boolean displayCrossfader = ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayCrossfader();
        int start = displayCrossfader ? 3 : 2;
        int n = end = displayCrossfader ? 5 : 6;
        if (displayCrossfader) {
            String crossfadeMode = t.getCrossfadeMode();
            ((MCUControlSurface)this.surface).setKnobLED(2, 0, "A".equals(crossfadeMode) ? 1 : ("B".equals(crossfadeMode) ? 127 : 64), upperBound);
        }
        boolean isEffectTrackBankActive = this.model.isEffectTrackBankActive();
        for (int i = 0; i < end; ++i) {
            ((MCUControlSurface)this.surface).setKnobLED(start + i, 2, isEffectTrackBankActive ? 0 : t.getSend(i).getValue(), upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        ITrack selectedTrack = this.model.getSelectedTrack();
        if (selectedTrack == null) {
            return;
        }
        switch (index) {
            case 0: {
                selectedTrack.resetVolume();
                break;
            }
            case 1: {
                selectedTrack.resetPan();
                break;
            }
            case 2: {
                if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayCrossfader()) {
                    selectedTrack.setCrossfadeMode("AB");
                    break;
                }
                if (this.model.isEffectTrackBankActive()) break;
                selectedTrack.getSend(0).resetValue();
                break;
            }
            default: {
                if (this.model.isEffectTrackBankActive()) break;
                selectedTrack.getSend(index - (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayCrossfader() ? 3 : 2)).resetValue();
            }
        }
    }
}

