/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.track;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.controller.mcu.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.StringUtils;

public class SendMode
extends AbstractTrackMode {
    public SendMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.model.getCurrentTrackBank().getTrack(extenderOffset + index).getSend(this.getCurrentSendIndex()).changeValue(value);
    }

    @Override
    public void updateDisplay() {
        if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            return;
        }
        if (this.model.isEffectTrackBankActive()) {
            ((MCUControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_TRACK);
            return;
        }
        this.drawDisplay2();
        if (!this.drawTrackHeader()) {
            return;
        }
        Display d = ((MCUControlSurface)this.surface).getDisplay();
        int sendIndex = this.getCurrentSendIndex();
        IChannelBank tb = this.model.getCurrentTrackBank();
        if (!tb.canEditSend(sendIndex)) {
            d.notify("Send channel " + (sendIndex + 1) + " does not exist.", true, false);
            return;
        }
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            d.setCell(1, i, t.getSend(sendIndex).getDisplayedValue(6));
        }
        d.done(1);
    }

    @Override
    protected boolean drawTrackHeader() {
        if (this.model.isEffectTrackBankActive()) {
            ((MCUControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_TRACK);
            return true;
        }
        if (!super.drawTrackHeader()) {
            return false;
        }
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayTrackNames()) {
            return true;
        }
        Display d = ((MCUControlSurface)this.surface).getDisplay();
        IChannelBank tb = this.model.getCurrentTrackBank();
        int sendIndex = this.getCurrentSendIndex();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            if (t.doesExist()) {
                d.setCell(0, i, StringUtils.shortenAndFixASCII(t.getSend(sendIndex).getName(6), 6));
                continue;
            }
            d.clearCell(0, i);
        }
        d.done(0);
        return true;
    }

    @Override
    protected void updateKnobLEDs() {
        if (this.model.isEffectTrackBankActive()) {
            ((MCUControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_TRACK);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        int upperBound = this.model.getValueChanger().getUpperBound();
        int sendIndex = this.getCurrentSendIndex();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, t.getSend(sendIndex).getValue(), upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.model.getCurrentTrackBank().getTrack(extenderOffset + index).getSend(this.getCurrentSendIndex()).resetValue();
    }

    private int getCurrentSendIndex() {
        return ((MCUControlSurface)this.surface).getModeManager().getActiveModeId() - Modes.MODE_SEND1;
    }
}

