/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.track;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;

public class PanMode
extends AbstractTrackMode {
    public PanMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(((MCUControlSurface)this.surface).getExtenderOffset() + index).changePan(value);
    }

    @Override
    public void updateDisplay() {
        if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            return;
        }
        this.drawDisplay2();
        if (!this.drawTrackHeader()) {
            return;
        }
        Display d = ((MCUControlSurface)this.surface).getDisplay();
        IChannelBank tb = this.model.getCurrentTrackBank();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            d.setCell(1, i, t.getPanStr(6));
        }
        d.done(1);
    }

    @Override
    protected boolean drawTrackHeader() {
        if (!super.drawTrackHeader()) {
            return false;
        }
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayTrackNames()) {
            return true;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        Display d = ((MCUControlSurface)this.surface).getDisplay();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            if (tb.getTrack(extenderOffset + i).doesExist()) {
                d.setCell(0, i, "Pan");
                continue;
            }
            d.clearCell(0, i);
        }
        d.done(0);
        return true;
    }

    @Override
    protected void updateKnobLEDs() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        int upperBound = this.model.getValueChanger().getUpperBound();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            ((MCUControlSurface)this.surface).setKnobLED(i, 1, t.doesExist() ? Math.max(t.getPan(), 1) : upperBound / 2, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.model.getCurrentTrackBank().getTrack(extenderOffset + index).resetPan();
    }
}

