/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.track;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class MasterMode
extends BaseMode {
    public MasterMode(MCUControlSurface surface, IModel model, boolean isTemporary) {
        super(surface, model);
        this.isTemporary = isTemporary;
    }

    @Override
    public void onActivate() {
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        this.setActive(false);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (index == 0) {
            this.model.getMasterTrack().changeVolume(value);
        } else if (index == 1) {
            this.model.getMasterTrack().changePan(value);
        }
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        switch (index) {
            case 0: {
                this.model.getMasterTrack().resetVolume();
                break;
            }
            case 1: {
                this.model.getMasterTrack().resetPan();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 6: {
                this.model.getProject().previous();
                break;
            }
            case 7: {
                this.model.getProject().next();
            }
        }
    }

    @Override
    public void updateDisplay() {
        if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            return;
        }
        this.drawDisplay2();
        Display d = ((MCUControlSurface)this.surface).getDisplay().clear();
        String projectName = StringUtils.fixASCII(this.model.getProject().getName());
        IMasterTrack master = this.model.getMasterTrack();
        IApplication application = this.model.getApplication();
        d.setCell(0, 0, "Volume").setCell(0, 1, "Pan").setBlock(0, 1, "Audio Engine:").setCell(0, 4, application.isEngineActive() ? " On" : " Off");
        d.setCell(0, 5, "Prjct:").setBlock(0, 3, projectName);
        d.setCell(1, 0, master.getVolumeStr(6)).setCell(1, 1, master.getPanStr(6)).setBlock(1, 1, application.isEngineActive() ? "  Turn off" : "  Turn on");
        d.setCell(1, 6, " <<").setCell(1, 7, " >>").allDone();
    }

    private void setActive(boolean enable) {
        IMasterTrack mt = this.model.getMasterTrack();
        mt.setVolumeIndication(enable);
        mt.setPanIndication(enable);
    }

    @Override
    protected void updateKnobLEDs() {
        IMasterTrack masterTrack = this.model.getMasterTrack();
        int upperBound = this.model.getValueChanger().getUpperBound();
        ((MCUControlSurface)this.surface).setKnobLED(0, 2, masterTrack.getVolume(), upperBound);
        ((MCUControlSurface)this.surface).setKnobLED(1, 1, masterTrack.getPan(), upperBound);
        for (int i = 0; i < 6; ++i) {
            ((MCUControlSurface)this.surface).setKnobLED(2 + i, 2, 0, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        IMasterTrack masterTrack = this.model.getMasterTrack();
        switch (index) {
            case 0: {
                masterTrack.resetVolume();
                break;
            }
            case 1: {
                masterTrack.resetPan();
                break;
            }
        }
    }
}

