/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.device;

import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.utils.StringUtils;

public class DeviceParamsMode
extends BaseMode {
    public DeviceParamsMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.model.getCursorDevice().changeParameter(extenderOffset + index, value);
    }

    @Override
    public void updateDisplay() {
        this.drawDisplay2();
        Display d = ((MCUControlSurface)this.surface).getDisplay().clear();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasSelectedDevice()) {
            d.notify("Please select a Device...", true, false);
            return;
        }
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            IParameter param = cd.getFXParam(extenderOffset + i);
            d.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName()) : "").setCell(1, i, param.getDisplayedValue(8));
        }
        d.allDone();
    }

    @Override
    protected void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        ICursorDevice cd = this.model.getCursorDevice();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            IParameter param = cd.getFXParam(extenderOffset + i);
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, param.doesExist() ? param.getValue() : 0, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.model.getCursorDevice().resetParameter(extenderOffset + index);
    }
}

