/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode.device;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.StringUtils;

public class DeviceBrowserMode
extends BaseMode {
    private static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private int selectionMode;
    private int filterColumn;

    public DeviceBrowserMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
        this.selectionMode = 0;
        this.filterColumn = -1;
    }

    @Override
    public void onDeactivate() {
        this.model.getBrowser().stopBrowsing(true);
    }

    @Override
    public void onValueKnob(int index, int value) {
        boolean direction;
        int speed = (int)this.model.getValueChanger().calcKnobSpeed(value, 1.0);
        boolean bl = direction = speed > 0;
        if (((MCUControlSurface)this.surface).isShiftPressed()) {
            speed *= 4;
        }
        speed = Math.abs(speed);
        if (direction) {
            this.selectNext(index, speed);
        } else {
            this.selectPrevious(index, speed);
        }
    }

    @Override
    public void updateDisplay() {
        IBrowser browser = this.model.getBrowser();
        Display d = ((MCUControlSurface)this.surface).getDisplay();
        boolean isPresetSession = browser.isPresetContentType();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!(!isPresetSession || browser.isActive() && cd.hasSelectedDevice())) {
            d.notify("No active Browsing Session. Select device and press Browser...");
            return;
        }
        d.clear();
        switch (this.selectionMode) {
            case 0: {
                for (int i = 0; i < 7; ++i) {
                    IBrowserColumn column = this.getFilterColumn(i);
                    String value = column != null && column.doesCursorExist() ? (column.getCursorName().equals(column.getWildcard()) ? "-" : column.getCursorName()) : "";
                    String name = column == null ? "" : StringUtils.shortenAndFixASCII(column.getName(), 6);
                    d.setCell(0, i, name).setCell(1, i, value);
                }
                String selectedResult = browser.getSelectedResult();
                d.setCell(0, 7, browser.getSelectedContentType()).setCell(1, 7, selectedResult == null || selectedResult.length() == 0 ? "-" : selectedResult);
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                for (int i = 0; i < browser.getNumFilterColumnEntries() && i < results.length; ++i) {
                    d.setBlock(i / 4, i % 4, (results[i].isSelected() ? ">" : " ") + StringUtils.fixASCII(results[i].getName()));
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] items = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < browser.getNumResults(); ++i) {
                    d.setBlock(i / 4, i % 4, (items[i].isSelected() ? ">" : " ") + StringUtils.fixASCII(items[i].getName()));
                }
                break;
            }
        }
        d.allDone();
    }

    @Override
    protected void resetParameter(int index) {
        if (this.selectionMode != 0) {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            IBrowserColumn fc = this.getFilterColumn(index);
            if (fc != null && fc.doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.getIndex();
            }
        }
    }

    @Override
    protected void updateKnobLEDs() {
        for (int i = 0; i < 8; ++i) {
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, 1);
        }
    }

    private IBrowserColumn getFilterColumn(int index) {
        IBrowser browser = this.model.getBrowser();
        int column = -1;
        boolean[] browserDisplayFilter = ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getBrowserDisplayFilter();
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            if (!browserDisplayFilter[i] || ++column != index) continue;
            return browser.getFilterColumn(i);
        }
        return null;
    }

    private void selectNext(int index, int count) {
        block3: {
            IBrowser browser;
            block2: {
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                IBrowserColumn fc = this.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) break block3;
                this.filterColumn = fc.getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                IBrowserColumn fc = this.getFilterColumn(index);
                if (fc == null || !fc.doesExist()) continue;
                this.filterColumn = fc.getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }
}

