/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.mode;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.controller.MCUDisplay;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.AbstractMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public abstract class BaseMode
extends AbstractMode<MCUControlSurface, MCUConfiguration> {
    public BaseMode(MCUControlSurface surface, IModel model) {
        super(surface, model);
        this.isTemporary = false;
    }

    @Override
    public void onRowButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int channel = ((MCUControlSurface)this.surface).getExtenderOffset() + index;
        if (row == 0) {
            this.resetParameter(index);
            return;
        }
        ITrack track = this.model.getCurrentTrackBank().getTrack(channel);
        if (row == 1) {
            track.toggleRecArm();
        } else if (row == 2) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                track.toggleAutoMonitor();
            } else {
                track.toggleSolo();
            }
        } else if (row == 3) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                track.toggleMonitor();
            } else {
                track.toggleMute();
            }
        }
    }

    protected abstract void resetParameter(int var1);

    @Override
    public void updateFirstRow() {
        IChannelBank tb = this.model.getCurrentTrackBank();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(extenderOffset + i);
            ((MCUControlSurface)this.surface).updateButton(0 + i, track.isRecArm() ? 127 : 0);
            ((MCUControlSurface)this.surface).updateButton(8 + i, track.isSolo() ? 127 : 0);
            ((MCUControlSurface)this.surface).updateButton(16 + i, track.isMute() ? 127 : 0);
            ((MCUControlSurface)this.surface).updateButton(24 + i, track.isSelected() ? 127 : 0);
        }
        this.updateKnobLEDs();
    }

    protected abstract void updateKnobLEDs();

    protected void drawDisplay2() {
        if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasDisplay2()) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        MCUDisplay d2 = ((MCUControlSurface)this.surface).getSecondDisplay();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        boolean isMainDevice = ((MCUControlSurface)this.surface).isMainDevice();
        for (int i = 0; i < 8; ++i) {
            ITrack t = tb.getTrack(extenderOffset + i);
            d2.setCell(0, i, StringUtils.shortenAndFixASCII(t.getName(), isMainDevice ? 6 : 7));
        }
        if (isMainDevice) {
            d2.setCell(0, 8, "Maste");
        }
        d2.done(0);
        d2.clearRow(1);
        if (isMainDevice) {
            IMasterTrack masterTrack = this.model.getMasterTrack();
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            ITrack selectedTrack = masterTrack.isSelected() ? masterTrack : tb.getSelectedTrack();
            d2.setBlock(1, 0, "Sel.track: ").setBlock(1, 1, selectedTrack == null ? "None" : StringUtils.fixASCII(selectedTrack.getName()));
            d2.setBlock(1, 2, "Sel.devce: ").setBlock(1, 3, cursorDevice.hasSelectedDevice() ? cursorDevice.getName() : "None");
        }
        d2.done(1);
    }
}

