/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.controller;

import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class MCUSegmentDisplay {
    private IMidiOutput output;
    private int[] transportBuffer = new int[10];
    private int[] assignmentBuffer = new int[2];

    public MCUSegmentDisplay(IMidiOutput output) {
        this.output = output;
    }

    public void setTransportPositionDisplay(String position) {
        boolean addDot = false;
        int pos = position.length() - 1;
        int i = 0;
        while (i < 10) {
            int c = 32;
            if (pos >= 0) {
                boolean isDot;
                char singleDigit = position.charAt(pos);
                --pos;
                boolean bl = isDot = singleDigit == ':';
                if (isDot) {
                    addDot = isDot;
                    continue;
                }
                c = singleDigit;
                if (addDot) {
                    c += 64;
                }
            }
            if (c != this.transportBuffer[i]) {
                this.output.sendCC(64 + i, c);
                this.transportBuffer[i] = c;
            }
            ++i;
            addDot = false;
        }
    }

    public void setAssignmentDisplay(String mode) {
        for (int i = 0; i < 2; ++i) {
            int c = mode.charAt(i);
            if (this.assignmentBuffer[i] == c) continue;
            int value = c >= 64 ? c - 64 : c;
            this.output.sendCC(75 - i, value);
            this.assignmentBuffer[i] = c;
        }
    }

    public void shutdown() {
        for (int i = 0; i < 12; ++i) {
            this.output.sendCC(64 + i, 32);
        }
    }
}

