/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.controller;

import de.mossgrabers.framework.controller.display.AbstractDisplay;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.LatestTaskExecutor;
import de.mossgrabers.framework.utils.StringUtils;

public class MCUDisplay
extends AbstractDisplay {
    private static final String SYSEX_DISPLAY_HEADER1 = "F0 00 00 66 14 12 ";
    private static final String SYSEX_DISPLAY_HEADER2 = "F0 00 00 67 15 13 ";
    private static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private boolean isFirst;
    private int charactersOfCell;
    private boolean hasMaster;
    private final LatestTaskExecutor[] executors = new LatestTaskExecutor[4];

    public MCUDisplay(IHost host, IMidiOutput output, boolean isFirst, boolean hasMaster) {
        super(host, output, 2, !isFirst && hasMaster ? 9 : 8, 56);
        this.isFirst = isFirst;
        this.hasMaster = hasMaster;
        this.charactersOfCell = this.noOfCharacters / this.noOfCells;
        for (int i = 0; i < 4; ++i) {
            this.executors[i] = new LatestTaskExecutor();
        }
    }

    @Override
    public AbstractDisplay clearRow(int row) {
        for (int i = 0; i < this.noOfCells; ++i) {
            this.clearCell(row, i);
        }
        return this;
    }

    @Override
    public MCUDisplay clearCell(int row, int cell) {
        this.cells[row * this.noOfCells + cell] = "         ".substring(0, this.charactersOfCell);
        return this;
    }

    @Override
    public Display setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() >= this.charactersOfCell) {
            this.cells[row * this.noOfCells + cell] = MCUDisplay.pad(value.substring(0, this.charactersOfCell), this.charactersOfCell);
            this.cells[row * this.noOfCells + cell + 1] = MCUDisplay.pad(value.substring(this.charactersOfCell), this.charactersOfCell);
        } else {
            this.setCell(row, cell, value);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public Display setCell(int row, int column, int value, Format format) {
        this.cells[row * this.noOfCells + column] = MCUDisplay.pad(Integer.toString(value), this.charactersOfCell - 1) + " ";
        return this;
    }

    @Override
    public Display setCell(int row, int column, String value) {
        try {
            this.cells[row * this.noOfCells + column] = MCUDisplay.pad(value, this.charactersOfCell - 1) + " ";
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.host.error("Display array index out of bounds.", ex);
        }
        return this;
    }

    @Override
    public void writeLine(int row, String text) {
        LatestTaskExecutor executor = this.executors[row + (this.isFirst ? 0 : 2)];
        if (executor != null) {
            executor.execute(() -> this.sendDisplayLine(row, text));
        }
    }

    private void sendDisplayLine(int row, String text) {
        String t = text;
        if (!this.isFirst && this.hasMaster) {
            if (row == 0) {
                t = t.substring(0, t.length() - 1) + 'r';
            }
            t = "  " + t;
        }
        int length = t.length();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = t.charAt(i);
        }
        StringBuilder code = new StringBuilder();
        if (this.isFirst) {
            code.append(SYSEX_DISPLAY_HEADER1);
        } else {
            code.append(SYSEX_DISPLAY_HEADER2);
        }
        if (row == 0) {
            code.append("00 ");
        } else {
            code.append("38 ");
        }
        this.output.sendSysex(code.append(StringUtils.toHexStr(array)).append("F7").toString());
    }

    @Override
    public void shutdown() {
        this.notify("Please start " + this.host.getName() + "...", true, false);
        for (int i = 0; i < 4; ++i) {
            this.executors[i] = null;
        }
    }

    private static String pad(String str, int length) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff < 0) {
            return text.substring(0, length);
        }
        if (diff > 0) {
            return text + SPACES[diff];
        }
        return text;
    }
}

