/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.controller;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUDisplay;
import de.mossgrabers.controller.mcu.controller.MCUSegmentDisplay;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.Arrays;
import java.util.List;

public class MCUControlSurface
extends AbstractControlSurface<MCUConfiguration> {
    public static final int MCU_ARM1 = 0;
    public static final int MCU_ARM2 = 1;
    public static final int MCU_ARM3 = 2;
    public static final int MCU_ARM4 = 3;
    public static final int MCU_ARM5 = 4;
    public static final int MCU_ARM6 = 5;
    public static final int MCU_ARM7 = 6;
    public static final int MCU_ARM8 = 7;
    public static final int MCU_SOLO1 = 8;
    public static final int MCU_SOLO2 = 9;
    public static final int MCU_SOLO3 = 10;
    public static final int MCU_SOLO4 = 11;
    public static final int MCU_SOLO5 = 12;
    public static final int MCU_SOLO6 = 13;
    public static final int MCU_SOLO7 = 14;
    public static final int MCU_SOLO8 = 15;
    public static final int MCU_MUTE1 = 16;
    public static final int MCU_MUTE2 = 17;
    public static final int MCU_MUTE3 = 18;
    public static final int MCU_MUTE4 = 19;
    public static final int MCU_MUTE5 = 20;
    public static final int MCU_MUTE6 = 21;
    public static final int MCU_MUTE7 = 22;
    public static final int MCU_MUTE8 = 23;
    public static final int MCU_SELECT1 = 24;
    public static final int MCU_SELECT2 = 25;
    public static final int MCU_SELECT3 = 26;
    public static final int MCU_SELECT4 = 27;
    public static final int MCU_SELECT5 = 28;
    public static final int MCU_SELECT6 = 29;
    public static final int MCU_SELECT7 = 30;
    public static final int MCU_SELECT8 = 31;
    public static final int MCU_VSELECT1 = 32;
    public static final int MCU_VSELECT2 = 33;
    public static final int MCU_VSELECT3 = 34;
    public static final int MCU_VSELECT4 = 35;
    public static final int MCU_VSELECT5 = 36;
    public static final int MCU_VSELECT6 = 37;
    public static final int MCU_VSELECT7 = 38;
    public static final int MCU_VSELECT8 = 39;
    public static final int MCU_MODE_IO = 40;
    public static final int MCU_MODE_SENDS = 41;
    public static final int MCU_MODE_PAN = 42;
    public static final int MCU_MODE_PLUGIN = 43;
    public static final int MCU_MODE_EQ = 44;
    public static final int MCU_MODE_DYN = 45;
    public static final int MCU_BANK_LEFT = 46;
    public static final int MCU_BANK_RIGHT = 47;
    public static final int MCU_TRACK_LEFT = 48;
    public static final int MCU_TRACK_RIGHT = 49;
    public static final int MCU_FLIP = 50;
    public static final int MCU_EDIT = 51;
    public static final int MCU_NAME_VALUE = 52;
    public static final int MCU_SMPTE_BEATS = 53;
    public static final int MCU_F1 = 54;
    public static final int MCU_F2 = 55;
    public static final int MCU_F3 = 56;
    public static final int MCU_F4 = 57;
    public static final int MCU_F5 = 58;
    public static final int MCU_F6 = 59;
    public static final int MCU_F7 = 60;
    public static final int MCU_F8 = 61;
    public static final int MCU_MIDI_TRACKS = 62;
    public static final int MCU_INPUTS = 63;
    public static final int MCU_AUDIO_TRACKS = 64;
    public static final int MCU_AUDIO_INSTR = 65;
    public static final int MCU_AUX = 66;
    public static final int MCU_BUSSES = 67;
    public static final int MCU_OUTPUTS = 68;
    public static final int MCU_USER = 69;
    public static final int MCU_SHIFT = 70;
    public static final int MCU_OPTION = 71;
    public static final int MCU_CONTROL = 72;
    public static final int MCU_ALT = 73;
    public static final int MCU_READ = 74;
    public static final int MCU_WRITE = 75;
    public static final int MCU_TRIM = 76;
    public static final int MCU_TOUCH = 77;
    public static final int MCU_LATCH = 78;
    public static final int MCU_GROUP = 79;
    public static final int MCU_SAVE = 80;
    public static final int MCU_UNDO = 81;
    public static final int MCU_CANCEL = 82;
    public static final int MCU_ENTER = 83;
    public static final int MCU_MARKER = 84;
    public static final int MCU_NUDGE = 85;
    public static final int MCU_REPEAT = 86;
    public static final int MCU_DROP = 87;
    public static final int MCU_REPLACE = 88;
    public static final int MCU_CLICK = 89;
    public static final int MCU_SOLO = 90;
    public static final int MCU_REWIND = 91;
    public static final int MCU_FORWARD = 92;
    public static final int MCU_STOP = 93;
    public static final int MCU_PLAY = 94;
    public static final int MCU_RECORD = 95;
    public static final int MCU_ARROW_UP = 96;
    public static final int MCU_ARROW_DOWN = 97;
    public static final int MCU_ARROW_LEFT = 98;
    public static final int MCU_ARROW_RIGHT = 99;
    public static final int MCU_ZOOM = 100;
    public static final int MCU_SCRUB = 101;
    public static final int MCU_USER_A = 102;
    public static final int MCU_USER_B = 103;
    public static final int MCU_FADER_TOUCH1 = 104;
    public static final int MCU_FADER_TOUCH2 = 105;
    public static final int MCU_FADER_TOUCH3 = 106;
    public static final int MCU_FADER_TOUCH4 = 107;
    public static final int MCU_FADER_TOUCH5 = 108;
    public static final int MCU_FADER_TOUCH6 = 109;
    public static final int MCU_FADER_TOUCH7 = 110;
    public static final int MCU_FADER_TOUCH8 = 111;
    public static final int MCU_FADER_MASTER = 112;
    public static final int MCU_SMPTE_LED = 113;
    public static final int MCU_BEATS_LED = 114;
    public static final int MCU_RUDE_SOLO_L = 115;
    public static final int MCU_RELAY_CLICK = 118;
    public static final int MCU_CC_VPOT1 = 16;
    public static final int MCU_CC_VPOT2 = 17;
    public static final int MCU_CC_VPOT3 = 18;
    public static final int MCU_CC_VPOT4 = 19;
    public static final int MCU_CC_VPOT5 = 20;
    public static final int MCU_CC_VPOT6 = 21;
    public static final int MCU_CC_VPOT7 = 22;
    public static final int MCU_CC_VPOT8 = 23;
    public static final int MCU_CC_JOG = 60;
    public static final int[] MCU_SYSEX_HEADER = new int[]{240, 0, 0, 102, 20};
    public static final String SYSEX_HDR = "F0 00 00 66 14 ";
    public static final int MCU_SYSEX_CMD_DISPLAY = 18;
    private static final int[] MCU_BUTTONS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 104, 105, 106, 107, 108, 109, 110, 111, 112, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 62, 63, 64, 65, 70, 71, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 86, 74, 75, 76, 77, 78, 81, 69, 89, 90, 88, 54, 55, 56, 57, 58, 59, 60, 61, 82, 83, 80, 84, 66, 67, 68, 79, 85, 87};
    private static final boolean[] MCU_BUTTON_UPDATE = new boolean[128];
    public static final int VUMODE_LED = 1;
    public static final int VUMODE_OFF = 2;
    public static final int VUMODE_LED_AND_LCD = 3;
    public static final int VUMODE_LCD = 4;
    public static final int KNOB_LED_MODE_SINGLE_DOT = 0;
    public static final int KNOB_LED_MODE_BOOST_CUT = 1;
    public static final int KNOB_LED_MODE_WRAP = 2;
    public static final int KNOB_LED_MODE_SPREAD = 3;
    private MCUDisplay secondDisplay;
    private MCUSegmentDisplay segmentDisplay;
    private int activeVuMode = 1;
    private int[] knobValues = new int[8];
    private final int extenderOffset;
    private boolean isMainDevice;
    private List<MCUControlSurface> surfaces;

    public MCUControlSurface(List<MCUControlSurface> surfaces, IHost host, ColorManager colorManager, MCUConfiguration configuration, IMidiOutput output, IMidiInput input, int extenderOffset, boolean isMainDevice) {
        super(host, configuration, colorManager, output, input, MCU_BUTTONS_ALL);
        this.surfaces = surfaces;
        this.extenderOffset = extenderOffset;
        this.isMainDevice = isMainDevice;
        this.shiftButtonId = 70;
        this.selectButtonId = 71;
        this.leftButtonId = 98;
        this.rightButtonId = 99;
        this.upButtonId = 96;
        this.downButtonId = 97;
        Arrays.fill(this.knobValues, -1);
    }

    @Override
    public void shutdown() {
        for (int button : this.getButtons()) {
            this.setButton(button, 0);
        }
        this.display.shutdown();
        this.secondDisplay.shutdown();
        this.segmentDisplay.shutdown();
    }

    @Override
    public void setButton(int button, int state) {
        this.output.sendNote(button, state);
    }

    public boolean shouldUpdateButton(int button) {
        return MCU_BUTTON_UPDATE[button];
    }

    public void setKnobLED(int index, int knobLEDMode, int value, int maxValue) {
        int rescale = (int)Math.round((double)value * 11.0 / (double)maxValue);
        int v = knobLEDMode << 4;
        if (this.knobValues[index] == (v += rescale)) {
            return;
        }
        this.knobValues[index] = v;
        this.output.sendCC(48 + index, v);
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        switch (code) {
            case 128: 
            case 144: {
                this.handleCC(0, data1, data2);
                break;
            }
            case 176: {
                this.handleCC(1, data1, data2);
                break;
            }
            default: {
                super.handleMidi(status, data1, data2);
            }
        }
    }

    public void setSecondDisplay(MCUDisplay secondDisplay) {
        this.secondDisplay = secondDisplay;
    }

    public MCUDisplay getSecondDisplay() {
        return this.secondDisplay;
    }

    public void setSegmentDisplay(MCUSegmentDisplay segmentDisplay) {
        this.segmentDisplay = segmentDisplay;
    }

    public MCUSegmentDisplay getSegmentDisplay() {
        return this.segmentDisplay;
    }

    public int getExtenderOffset() {
        return this.extenderOffset;
    }

    @Override
    protected void scheduledFlush() {
        super.scheduledFlush();
        if (this.secondDisplay != null) {
            this.secondDisplay.flush();
        }
    }

    public void switchVuMode(int mode) {
        this.output.sendSysex(SYSEX_HDR + "21 00 F7");
        if (this.activeVuMode != mode) {
            this.activeVuMode = this.activeVuMode < 5 ? mode : 1;
        }
        IMidiOutput out = this.getOutput();
        switch (this.activeVuMode) {
            case 1: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 01 F7");
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 03 F7");
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 06 F7");
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 8; ++i) {
                    out.sendChannelAftertouch(0 + (i << 4), 0);
                    out.sendSysex("F0 00 00 66 14 20 0" + i + " 00 F7");
                }
                break;
            }
        }
    }

    @Override
    public boolean isGridNote(int note) {
        return false;
    }

    @Override
    public boolean isPressed(int button) {
        for (MCUControlSurface surface : this.surfaces) {
            if (!surface.isSinglePressed(button)) continue;
            return true;
        }
        return false;
    }

    private boolean isSinglePressed(int button) {
        return super.isPressed(button);
    }

    public boolean isMainDevice() {
        return this.isMainDevice;
    }

    static {
        Arrays.fill(MCU_BUTTON_UPDATE, false);
    }
}

