/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.command.trigger;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SendSelectCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    private List<Integer> modeIds = new ArrayList<Integer>();

    public SendSelectCommand(IModel model, MCUControlSurface surface) {
        super(model, surface);
        Collections.addAll(this.modeIds, Modes.MODE_SEND1, Modes.MODE_SEND2, Modes.MODE_SEND3, Modes.MODE_SEND4, Modes.MODE_SEND5, Modes.MODE_SEND6, Modes.MODE_SEND7, Modes.MODE_SEND8);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.model.isEffectTrackBankActive()) {
            return;
        }
        Integer activeModeId = ((MCUControlSurface)this.surface).getModeManager().getActiveModeId();
        int index = this.modeIds.indexOf(activeModeId) + 1;
        if (index < 0 || index >= this.modeIds.size()) {
            index = 0;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getTrack(0);
        if (tb.canEditSend(index)) {
            ((MCUControlSurface)this.surface).getModeManager().setActiveMode(this.modeIds.get(index));
        } else if (track.getSend(0).doesExist()) {
            ((MCUControlSurface)this.surface).getModeManager().setActiveMode(this.modeIds.get(0));
        }
    }
}

