/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.command.trigger;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SelectCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    protected int index;
    protected int channel;

    public SelectCommand(int index, IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.index = index;
        this.channel = ((MCUControlSurface)this.surface).getExtenderOffset() + this.index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.index == 8) {
            this.model.getMasterTrack().select();
            return;
        }
        Display display = ((MCUControlSurface)this.surface).getDisplay();
        if (((MCUControlSurface)this.surface).isPressed(41)) {
            IChannelBank effectTrackBank = this.model.getEffectTrackBank();
            if (effectTrackBank != null && effectTrackBank.getTrack(this.channel).doesExist()) {
                ((MCUControlSurface)this.surface).getModeManager().setActiveMode(Modes.MODE_SEND1 + this.index);
                display.notify("Send channel " + (this.channel + 1) + " selected.");
            } else {
                display.notify("Send channel " + (this.channel + 1) + " does not exist.");
            }
            ((MCUControlSurface)this.surface).setButtonConsumed(41);
            return;
        }
        if (((MCUControlSurface)this.surface).isShiftPressed()) {
            MCUConfiguration configuration = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
            configuration.setNewClipLength(this.index);
            display.notify("New clip length: " + AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[configuration.getNewClipLength()]);
            return;
        }
        if (((MCUControlSurface)this.surface).isSelectPressed()) {
            this.model.getCurrentTrackBank().getTrack(this.channel).stop();
            return;
        }
        this.model.getCurrentTrackBank().getTrack(this.channel).selectAndMakeVisible();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || this.index >= 8) {
            return;
        }
        ((MCUControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.NEW_CLIP_LENGTH_VALUES[this.index]);
        ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).setNewClipLength(this.index);
    }
}

