/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.command.trigger;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class KeyCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    protected Key key;

    public KeyCommand(Key key, IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.key = key;
    }

    @Override
    public void execute(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        switch (this.key) {
            case ENTER: {
                if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
                    this.model.getBrowser().stopBrowsing(true);
                    modeManager.restoreMode();
                    break;
                }
                this.model.getApplication().enter();
                break;
            }
            case ESCAPE: {
                if (modeManager.isActiveMode(Modes.MODE_BROWSER)) {
                    this.model.getBrowser().stopBrowsing(false);
                    modeManager.restoreMode();
                    break;
                }
                this.model.getApplication().escape();
            }
        }
    }

    public static enum Key {
        ENTER,
        ESCAPE;

    }
}

