/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.command.trigger;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AutomationCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    private int index;

    public AutomationCommand(int index, IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITransport transport = this.model.getTransport();
        switch (this.index) {
            case 0: {
                if (((MCUControlSurface)this.surface).isSelectPressed()) {
                    this.model.getTransport().resetAutomationOverrides();
                    break;
                }
                if (!transport.isWritingArrangerAutomation()) break;
                transport.toggleWriteArrangerAutomation();
                break;
            }
            case 1: {
                transport.setAutomationWriteMode(ITransport.AUTOMATION_MODES_VALUES[2]);
                if (transport.isWritingArrangerAutomation()) break;
                transport.toggleWriteArrangerAutomation();
                break;
            }
            case 2: {
                transport.toggleWriteClipLauncherAutomation();
                break;
            }
            case 3: {
                transport.setAutomationWriteMode(ITransport.AUTOMATION_MODES_VALUES[1]);
                if (transport.isWritingArrangerAutomation()) break;
                transport.toggleWriteArrangerAutomation();
                break;
            }
            case 4: {
                transport.setAutomationWriteMode(ITransport.AUTOMATION_MODES_VALUES[0]);
                if (transport.isWritingArrangerAutomation()) break;
                transport.toggleWriteArrangerAutomation();
            }
        }
    }
}

