/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu.command.pitchbend;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.framework.command.core.AbstractPitchbendCommand;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;

public class PitchbendVolumeCommand
extends AbstractPitchbendCommand<MCUControlSurface, MCUConfiguration> {
    public PitchbendVolumeCommand(IModel model, MCUControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void onPitchbend(int channel, int data1, int data2) {
        double value = Math.min((double)(data2 * 127) + (double)data1, (double)(this.model.getValueChanger().getUpperBound() - 1));
        if (channel == 8) {
            if (((MCUControlSurface)this.surface).isShiftPressed()) {
                this.model.getTransport().setMetronomeVolume(value);
            } else {
                this.model.getMasterTrack().setVolume(value);
            }
            return;
        }
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack track = tb.getTrack(extenderOffset + channel);
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).useFadersAsKnobs()) {
            ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
            if (modeManager.isActiveMode(Modes.MODE_VOLUME)) {
                track.setVolume(value);
            } else if (modeManager.isActiveMode(Modes.MODE_PAN)) {
                track.setPan(value);
            } else if (modeManager.isActiveMode(Modes.MODE_TRACK)) {
                this.handleTrack(channel, value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND1)) {
                track.getSend(0).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND2)) {
                track.getSend(1).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND3)) {
                track.getSend(2).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND4)) {
                track.getSend(3).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND5)) {
                track.getSend(4).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND6)) {
                track.getSend(5).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND7)) {
                track.getSend(6).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_SEND8)) {
                track.getSend(7).setValue(value);
            } else if (modeManager.isActiveMode(Modes.MODE_DEVICE_PARAMS)) {
                this.model.getCursorDevice().setParameter(extenderOffset + channel, (int)value);
            }
            return;
        }
        track.setVolume(value);
    }

    private void handleTrack(int index, double value) {
        ITrack selectedTrack = this.model.getSelectedTrack();
        switch (index) {
            case 0: {
                selectedTrack.setVolume(value);
                break;
            }
            case 1: {
                selectedTrack.setPan(value);
                break;
            }
            case 2: {
                if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayCrossfader()) {
                    double range = (double)this.model.getValueChanger().getUpperBound() / 3.0;
                    selectedTrack.setCrossfadeModeAsNumber((int)Math.round(value / range));
                    break;
                }
                if (this.model.isEffectTrackBankActive()) break;
                selectedTrack.getSend(0).setValue(value);
                break;
            }
            default: {
                if (this.model.isEffectTrackBankActive()) break;
                selectedTrack.getSend(index - (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isDisplayCrossfader() ? 3 : 2)).setValue(value);
            }
        }
    }
}

