/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu;

import de.mossgrabers.controller.mcu.MCUConfiguration;
import de.mossgrabers.controller.mcu.command.continuous.PlayPositionTempoCommand;
import de.mossgrabers.controller.mcu.command.pitchbend.PitchbendVolumeCommand;
import de.mossgrabers.controller.mcu.command.trigger.AssignableCommand;
import de.mossgrabers.controller.mcu.command.trigger.AutomationCommand;
import de.mossgrabers.controller.mcu.command.trigger.CursorCommand;
import de.mossgrabers.controller.mcu.command.trigger.DevicesCommand;
import de.mossgrabers.controller.mcu.command.trigger.FaderTouchCommand;
import de.mossgrabers.controller.mcu.command.trigger.GrooveCommand;
import de.mossgrabers.controller.mcu.command.trigger.KeyCommand;
import de.mossgrabers.controller.mcu.command.trigger.MCURecordCommand;
import de.mossgrabers.controller.mcu.command.trigger.OverdubCommand;
import de.mossgrabers.controller.mcu.command.trigger.ScrubCommand;
import de.mossgrabers.controller.mcu.command.trigger.SelectCommand;
import de.mossgrabers.controller.mcu.command.trigger.SendSelectCommand;
import de.mossgrabers.controller.mcu.command.trigger.ShiftCommand;
import de.mossgrabers.controller.mcu.command.trigger.TempoTicksCommand;
import de.mossgrabers.controller.mcu.command.trigger.ToggleDisplayCommand;
import de.mossgrabers.controller.mcu.command.trigger.TracksCommand;
import de.mossgrabers.controller.mcu.command.trigger.ZoomCommand;
import de.mossgrabers.controller.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mcu.controller.MCUDisplay;
import de.mossgrabers.controller.mcu.controller.MCUSegmentDisplay;
import de.mossgrabers.controller.mcu.mode.Modes;
import de.mossgrabers.controller.mcu.mode.device.DeviceBrowserMode;
import de.mossgrabers.controller.mcu.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.mcu.mode.track.MasterMode;
import de.mossgrabers.controller.mcu.mode.track.PanMode;
import de.mossgrabers.controller.mcu.mode.track.SendMode;
import de.mossgrabers.controller.mcu.mode.track.TrackMode;
import de.mossgrabers.controller.mcu.mode.track.VolumeMode;
import de.mossgrabers.controller.mcu.view.ControlView;
import de.mossgrabers.controller.mcu.view.Views;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.command.trigger.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.DuplicateCommand;
import de.mossgrabers.framework.command.trigger.MarkerCommand;
import de.mossgrabers.framework.command.trigger.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.MoveTrackBankCommand;
import de.mossgrabers.framework.command.trigger.NopCommand;
import de.mossgrabers.framework.command.trigger.application.LayoutCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.application.SaveCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.device.DeviceOnOffCommand;
import de.mossgrabers.framework.command.trigger.track.ToggleTrackBanksCommand;
import de.mossgrabers.framework.command.trigger.track.ToggleVUCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.PunchInCommand;
import de.mossgrabers.framework.command.trigger.transport.PunchOutCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.Relative2ValueChanger;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITrackBank;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.Mode;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.view.View;
import de.mossgrabers.framework.view.ViewManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MCUControllerSetup
extends AbstractControllerSetup<MCUControlSurface, MCUConfiguration> {
    public static final int MCU_BUTTON_STATE_ON = 127;
    public static final int MCU_BUTTON_STATE_OFF = 0;
    private static final Integer COMMAND_NOTE_EDITOR = 150;
    private static final Integer COMMAND_AUTOMATION_EDITOR = 151;
    private static final Integer COMMAND_TOGGLE_DEVICE = 152;
    private static final Integer COMMAND_MIXER = 153;
    private static final Integer COMMAND_TEMPO_TICKS = 154;
    private static final Integer COMMAND_ENTER = 155;
    private static final Integer COMMAND_CANCEL = 156;
    private static final Integer COMMAND_FLIP = 157;
    private static final Integer COMMAND_GROOVE = 158;
    private static final Integer COMMAND_OVERDUB = 159;
    private static final Integer COMMAND_SCRUB = 160;
    private static final Integer COMMAND_FOOTSWITCH1 = 161;
    private static final Integer COMMAND_FOOTSWITCH2 = 162;
    private static final Integer COMMAND_F1 = 163;
    private static final Integer COMMAND_F2 = 164;
    private static final Integer COMMAND_F3 = 165;
    private static final Integer COMMAND_F4 = 166;
    private static final Integer COMMAND_F5 = 167;
    private static final Integer COMMAND_TOGGLE_DISPLAY = 168;
    private static final Integer COMMAND_LAYOUT_ARRANGE = 169;
    private static final Integer COMMAND_LAYOUT_MIX = 170;
    private static final Integer COMMAND_LAYOUT_EDIT = 171;
    private static final Integer COMMAND_CONTROL = 172;
    private static final Integer COMMAND_ALT = 173;
    private static final Map<Integer, String> MODE_ACRONYMS = new HashMap<Integer, String>();
    private final int[] masterVuValues = new int[2];
    private int masterFaderValue = -1;
    private final int[] vuValues = new int[36];
    private final int[] faderValues = new int[36];
    private final int numMCUDevices;

    public MCUControllerSetup(IHost host, ISetupFactory factory, ISettingsUI settings, int numMCUDevices) {
        super(factory, host, settings);
        this.numMCUDevices = numMCUDevices;
        Arrays.fill(this.vuValues, -1);
        Arrays.fill(this.faderValues, -1);
        Arrays.fill(this.masterVuValues, -1);
        this.colorManager = new ColorManager();
        this.valueChanger = new Relative2ValueChanger(16242, 100, 10.0);
        this.configuration = new MCUConfiguration(this.valueChanger);
    }

    @Override
    public void flush() {
        this.flushSurfaces();
        this.updateButtons();
        this.updateMode(((MCUControlSurface)this.getSurface()).getModeManager().getActiveModeId());
    }

    @Override
    protected void createModel() {
        this.model = this.factory.createModel(this.colorManager, this.valueChanger, this.scales, 8 * this.numMCUDevices, 8, 8, 8, 8, true, 8 * this.numMCUDevices, -1, 0, 0);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addTrackSelectionObserver(this::handleTrackChange);
        this.model.getMasterTrack().addTrackSelectionObserver((index, isSelected) -> {
            ModeManager modeManager = ((MCUControlSurface)this.getSurface()).getModeManager();
            if (isSelected) {
                modeManager.setActiveMode(Modes.MODE_MASTER);
            } else {
                modeManager.restoreMode();
            }
        });
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        for (int i = 0; i < this.numMCUDevices; ++i) {
            IMidiOutput output = midiAccess.createOutput(i);
            IMidiInput input = midiAccess.createInput(i, null, new String[0]);
            MCUControlSurface surface = new MCUControlSurface(this.surfaces, this.model.getHost(), this.colorManager, (MCUConfiguration)this.configuration, output, input, 8 * (this.numMCUDevices - i - 1), i == 0);
            this.surfaces.add(surface);
            surface.setDisplay(new MCUDisplay(this.model.getHost(), output, true, false));
            surface.setSecondDisplay(new MCUDisplay(this.model.getHost(), output, false, i == 0));
            surface.setSegmentDisplay(new MCUSegmentDisplay(output));
            surface.getModeManager().setDefaultMode(Modes.MODE_VOLUME);
        }
    }

    @Override
    protected void createModes() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            ModeManager modeManager = surface.getModeManager();
            modeManager.registerMode(Modes.MODE_TRACK, new TrackMode(surface, this.model));
            modeManager.registerMode(Modes.MODE_VOLUME, new VolumeMode(surface, this.model));
            modeManager.registerMode(Modes.MODE_PAN, new PanMode(surface, this.model));
            SendMode modeSend = new SendMode(surface, this.model);
            for (int i = 0; i < 8; ++i) {
                modeManager.registerMode(Modes.MODE_SEND1 + i, modeSend);
            }
            modeManager.registerMode(Modes.MODE_DEVICE_PARAMS, new DeviceParamsMode(surface, this.model));
            modeManager.registerMode(Modes.MODE_BROWSER, new DeviceBrowserMode(surface, this.model));
            modeManager.registerMode(Modes.MODE_MASTER, new MasterMode(surface, this.model, false));
        }
    }

    @Override
    protected void createObservers() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            surface.getModeManager().addModeListener((oldMode, newMode) -> {
                for (int d = 0; d < this.numMCUDevices; ++d) {
                    MCUControlSurface s = (MCUControlSurface)this.getSurface(d);
                    if (s.equals(surface)) continue;
                    s.getModeManager().setActiveMode(newMode);
                }
                this.updateMode(null);
                this.updateMode(newMode);
            });
        }
        ((MCUConfiguration)this.configuration).addSettingObserver(AbstractConfiguration.ENABLE_VU_METERS, () -> {
            for (int index = 0; index < this.numMCUDevices; ++index) {
                MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
                surface.switchVuMode(((MCUConfiguration)this.configuration).isEnableVUMeters() ? 3 : 2);
                Mode activeMode = surface.getModeManager().getActiveMode();
                if (activeMode != null) {
                    activeMode.updateDisplay();
                }
                ((MCUDisplay)surface.getDisplay()).forceFlush();
            }
        });
    }

    @Override
    protected void createViews() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            ViewManager viewManager = surface.getViewManager();
            viewManager.registerView(Views.VIEW_CONTROL, new ControlView(surface, this.model));
        }
    }

    @Override
    protected void registerTriggerCommands() {
        MCUControlSurface surface = (MCUControlSurface)this.getSurface();
        this.addTriggerCommand(COMMAND_FOOTSWITCH1, 102, new AssignableCommand(0, this.model, surface));
        this.addTriggerCommand(COMMAND_FOOTSWITCH2, 103, new AssignableCommand(1, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_REWIND, 91, new WindCommand(this.model, surface, false));
        this.addTriggerCommand(Commands.COMMAND_FORWARD, 92, new WindCommand(this.model, surface, true));
        this.addTriggerCommand(Commands.COMMAND_LOOP, 86, new ToggleLoopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_STOP, 93, new StopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PLAY, 94, new PlayCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_RECORD, 95, new MCURecordCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_SCRUB, 101, new ScrubCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_LEFT, 98, new CursorCommand(CursorCommand.Direction.LEFT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_RIGHT, 99, new CursorCommand(CursorCommand.Direction.RIGHT, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_UP, 96, new CursorCommand(CursorCommand.Direction.UP, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ARROW_DOWN, 97, new CursorCommand(CursorCommand.Direction.DOWN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_ZOOM, 100, new ZoomCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_TOGGLE_DISPLAY, 52, new ToggleDisplayCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_TEMPO_TICKS, 53, new TempoTicksCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SHIFT, 70, new ShiftCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SELECT, 71, new NopCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PUNCH_IN, 59, new PunchInCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PUNCH_OUT, 60, new PunchOutCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_F1, 54, new AssignableCommand(2, this.model, surface));
        this.addTriggerCommand(COMMAND_F2, 55, new AssignableCommand(3, this.model, surface));
        this.addTriggerCommand(COMMAND_F3, 56, new AssignableCommand(4, this.model, surface));
        this.addTriggerCommand(COMMAND_F4, 57, new AssignableCommand(5, this.model, surface));
        this.addTriggerCommand(COMMAND_F5, 58, new AssignableCommand(6, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TRACK, 40, new TracksCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_PAN_SEND, 42, new ModeSelectCommand(Modes.MODE_PAN, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SENDS, 41, new SendSelectCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DEVICE, 43, new DevicesCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MOVE_TRACK_LEFT, 44, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, true, true));
        this.addTriggerCommand(Commands.COMMAND_MOVE_TRACK_RIGHT, 45, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, true, false));
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_READ, 74, new AutomationCommand(0, this.model, surface));
        AutomationCommand writeCommand = new AutomationCommand(1, this.model, surface);
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_WRITE, 75, writeCommand);
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_WRITE, 79, writeCommand);
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_TRIM, 76, new AutomationCommand(2, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_TOUCH, 77, new AutomationCommand(3, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_AUTOMATION_LATCH, 78, new AutomationCommand(4, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_UNDO, 81, new UndoCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_NOTE_EDITOR, 62, new PaneCommand(PaneCommand.Panels.NOTE, this.model, surface));
        this.addTriggerCommand(COMMAND_AUTOMATION_EDITOR, 63, new PaneCommand(PaneCommand.Panels.AUTOMATION, this.model, surface));
        this.addTriggerCommand(COMMAND_TOGGLE_DEVICE, 64, new PaneCommand(PaneCommand.Panels.DEVICE, this.model, surface));
        this.addTriggerCommand(COMMAND_MIXER, 65, new PaneCommand(PaneCommand.Panels.MIXER, this.model, surface));
        this.addTriggerCommand(COMMAND_LAYOUT_ARRANGE, 66, new LayoutCommand("ARRANGE", this.model, surface));
        this.addTriggerCommand(COMMAND_LAYOUT_MIX, 67, new LayoutCommand("MIX", this.model, surface));
        this.addTriggerCommand(COMMAND_LAYOUT_EDIT, 68, new LayoutCommand("EDIT", this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_BROWSE, 69, new BrowserCommand(Modes.MODE_BROWSER, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_METRONOME, 89, new MetronomeCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_GROOVE, 90, new GrooveCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_OVERDUB, 88, new OverdubCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TAP_TEMPO, 85, new TapTempoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DUPLICATE, 87, new DuplicateCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_DEVICE_ON_OFF, 61, new DeviceOnOffCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_CONTROL, 72, new NopCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_ALT, 73, new NopCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_FLIP, 50, new ToggleTrackBanksCommand(this.model, surface));
        this.addTriggerCommand(COMMAND_CANCEL, 82, new KeyCommand(KeyCommand.Key.ESCAPE, this.model, surface));
        this.addTriggerCommand(COMMAND_ENTER, 83, new KeyCommand(KeyCommand.Key.ENTER, this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MOVE_BANK_LEFT, 46, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, false, true));
        this.addTriggerCommand(Commands.COMMAND_MOVE_BANK_RIGHT, 47, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, false, false));
        this.addTriggerCommand(Commands.COMMAND_MOVE_TRACK_LEFT, 48, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, true, true));
        this.addTriggerCommand(Commands.COMMAND_MOVE_TRACK_RIGHT, 49, new MoveTrackBankCommand(this.model, surface, Modes.MODE_DEVICE_PARAMS, true, false));
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerTriggerCommand(Commands.COMMAND_NEW, new NewCommand(this.model, surface));
        viewManager.registerTriggerCommand(Commands.COMMAND_TAP_TEMPO, new TapTempoCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_SAVE, 80, new SaveCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MARKER, 84, new MarkerCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_TOGGLE_VU, 51, new ToggleVUCommand(this.model, surface));
        this.addTriggerCommand(Commands.COMMAND_MASTERTRACK, 112, new SelectCommand(8, this.model, surface));
        this.registerTriggerCommandsToAllDevices();
    }

    protected void registerTriggerCommandsToAllDevices() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            ViewManager viewManager = surface.getViewManager();
            for (int i = 0; i < 8; ++i) {
                Integer commandID = Commands.COMMAND_ROW_SELECT_1 + i;
                viewManager.registerTriggerCommand(commandID, new SelectCommand(i, this.model, surface));
                surface.assignTriggerCommand(24 + i, commandID);
                commandID = Commands.COMMAND_FADER_TOUCH_1 + i;
                viewManager.registerTriggerCommand(commandID, new FaderTouchCommand(i, this.model, surface));
                surface.assignTriggerCommand(104 + i, commandID);
                this.addTriggerCommand(Commands.COMMAND_ROW1_1 + i, 32 + i, new ButtonRowModeCommand(0, i, this.model, surface), index);
                this.addTriggerCommand(Commands.COMMAND_ROW2_1 + i, 0 + i, new ButtonRowModeCommand(1, i, this.model, surface), index);
                this.addTriggerCommand(Commands.COMMAND_ROW3_1 + i, 8 + i, new ButtonRowModeCommand(2, i, this.model, surface), index);
                this.addTriggerCommand(Commands.COMMAND_ROW4_1 + i, 16 + i, new ButtonRowModeCommand(3, i, this.model, surface), index);
            }
            viewManager.registerPitchbendCommand(new PitchbendVolumeCommand(this.model, surface));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        MCUControlSurface surface = (MCUControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.registerContinuousCommand(Commands.CONT_COMMAND_PLAY_POSITION, new PlayPositionTempoCommand(this.model, surface));
        surface.assignContinuousCommand(60, 1, Commands.CONT_COMMAND_PLAY_POSITION);
        for (int index = 0; index < this.numMCUDevices; ++index) {
            surface = (MCUControlSurface)this.getSurface(index);
            viewManager = surface.getViewManager();
            for (int i = 0; i < 8; ++i) {
                Integer commandID = Commands.CONT_COMMAND_KNOB1 + i;
                viewManager.registerContinuousCommand(commandID, new KnobRowModeCommand(i, this.model, surface));
                surface.assignContinuousCommand(16 + i, 1, commandID);
            }
        }
    }

    @Override
    public void startup() {
        for (int index = 0; index < this.numMCUDevices; ++index) {
            MCUControlSurface surface = (MCUControlSurface)this.getSurface(index);
            surface.switchVuMode(1);
            surface.getViewManager().setActiveView(Views.VIEW_CONTROL);
            surface.getModeManager().setActiveMode(Modes.MODE_PAN);
        }
    }

    private void updateButtons() {
        MCUControlSurface surface = (MCUControlSurface)this.getSurface();
        Integer mode = surface.getModeManager().getActiveModeId();
        if (mode == null) {
            return;
        }
        this.updateVUandFaders();
        this.updateSegmentDisplay();
        ITransport t = this.model.getTransport();
        boolean isShift = surface.isShiftPressed();
        boolean isFlipRecord = ((MCUConfiguration)this.configuration).isFlipRecord();
        boolean isRecordShifted = isShift && !isFlipRecord || !isShift && isFlipRecord;
        boolean isTrackOn = Modes.MODE_TRACK.equals(mode) || Modes.MODE_VOLUME.equals(mode);
        boolean isPanOn = Modes.MODE_PAN.equals(mode);
        boolean isSendOn = mode >= Modes.MODE_SEND1 && mode <= Modes.MODE_SEND8;
        boolean isDeviceOn = Modes.MODE_DEVICE_PARAMS.equals(mode);
        boolean isLEDOn = surface.isPressed(71) ? this.model.isCursorTrackPinned() : isTrackOn;
        surface.updateButton(40, isLEDOn ? 127 : 0);
        surface.updateButton(42, isPanOn ? 127 : 0);
        surface.updateButton(41, isSendOn ? 127 : 0);
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean isOn = surface.isPressed(71) ? cursorDevice.isPinned() : isDeviceOn;
        surface.updateButton(43, isOn ? 127 : 0);
        surface.updateButton(69, Modes.MODE_BROWSER.equals(mode) ? 127 : 0);
        ITransport transport = this.model.getTransport();
        String automationWriteMode = transport.getAutomationWriteMode();
        boolean writingArrangerAutomation = transport.isWritingArrangerAutomation();
        surface.updateButton(59, transport.isPunchInEnabled() ? 127 : 0);
        surface.updateButton(60, transport.isPunchOutEnabled() ? 127 : 0);
        surface.updateButton(74, !writingArrangerAutomation ? 127 : 0);
        int writeState = writingArrangerAutomation && ITransport.AUTOMATION_MODES_VALUES[2].equals(automationWriteMode) ? 127 : 0;
        surface.updateButton(75, writeState);
        surface.updateButton(79, writeState);
        surface.updateButton(76, transport.isWritingClipLauncherAutomation() ? 127 : 0);
        surface.updateButton(77, writingArrangerAutomation && ITransport.AUTOMATION_MODES_VALUES[1].equals(automationWriteMode) ? 127 : 0);
        surface.updateButton(78, writingArrangerAutomation && ITransport.AUTOMATION_MODES_VALUES[0].equals(automationWriteMode) ? 127 : 0);
        View view = surface.getViewManager().getView(Views.VIEW_CONTROL);
        surface.updateButton(91, ((WindCommand)view.getTriggerCommand(Commands.COMMAND_REWIND)).isRewinding() ? 127 : 0);
        surface.updateButton(92, ((WindCommand)view.getTriggerCommand(Commands.COMMAND_FORWARD)).isForwarding() ? 127 : 0);
        surface.updateButton(86, t.isLoop() ? 127 : 0);
        surface.updateButton(93, !t.isPlaying() ? 127 : 0);
        surface.updateButton(94, t.isPlaying() ? 127 : 0);
        surface.updateButton(95, isRecordShifted ? (t.isLauncherOverdub() ? 127 : 0) : (t.isRecording() ? 127 : 0));
        surface.updateButton(52, ((MCUConfiguration)surface.getConfiguration()).isDisplayTrackNames() ? 127 : 0);
        surface.updateButton(100, ((MCUConfiguration)surface.getConfiguration()).isZoomState() ? 127 : 0);
        surface.updateButton(101, surface.getModeManager().isActiveMode(Modes.MODE_DEVICE_PARAMS) ? 127 : 0);
        surface.updateButton(62, 0);
        surface.updateButton(63, 0);
        surface.updateButton(64, surface.isShiftPressed() && cursorDevice.isWindowOpen() ? 127 : 0);
        surface.updateButton(65, 0);
        surface.updateButton(89, (isShift ? t.isMetronomeTicksOn() : t.isMetronomeOn()) ? 127 : 0);
        surface.updateButton(90, this.model.getGroove().getParameters()[0].getValue() > 0 ? 127 : 0);
        surface.updateButton(88, (isShift ? t.isLauncherOverdub() : t.isArrangerOverdub()) ? 127 : 0);
        surface.updateButton(50, this.model.isEffectTrackBankActive() ? 127 : 0);
        boolean displayTicks = ((MCUConfiguration)this.configuration).isDisplayTicks();
        surface.updateButton(53, displayTicks ? 0 : 127);
        surface.updateButton(113, displayTicks ? 127 : 0);
        surface.updateButton(114, displayTicks ? 0 : 127);
        surface.updateButton(84, this.model.getArranger().areCueMarkersVisible() ? 127 : 0);
    }

    private void updateSegmentDisplay() {
        if (!((MCUConfiguration)this.configuration).hasSegmentDisplay()) {
            return;
        }
        ITransport t = this.model.getTransport();
        String positionText = t.getPositionText();
        if (((MCUConfiguration)this.configuration).isDisplayTicks()) {
            positionText = positionText + " ";
        } else {
            String tempoStr = t.formatTempoNoFraction(t.getTempo());
            int pos = positionText.lastIndexOf(58);
            if (tempoStr.length() < 3) {
                tempoStr = "0" + tempoStr;
            }
            positionText = positionText.substring(0, pos + 1) + tempoStr;
        }
        ((MCUControlSurface)this.getSurface()).getSegmentDisplay().setTransportPositionDisplay(positionText);
    }

    private void updateVUandFaders() {
        IMidiOutput output;
        MCUControlSurface surface;
        double upperBound = this.valueChanger.getUpperBound();
        boolean enableVUMeters = ((MCUConfiguration)this.configuration).isEnableVUMeters();
        boolean hasMotorFaders = ((MCUConfiguration)this.configuration).hasMotorFaders();
        IChannelBank tb = this.model.getCurrentTrackBank();
        for (int index = 0; index < this.numMCUDevices; ++index) {
            surface = (MCUControlSurface)this.getSurface(index);
            output = surface.getOutput();
            int extenderOffset = surface.getExtenderOffset();
            for (int i = 0; i < 8; ++i) {
                int vu;
                int channel = extenderOffset + i;
                ITrack track = tb.getTrack(channel);
                if (enableVUMeters && (vu = track.getVu()) != this.vuValues[channel]) {
                    this.vuValues[channel] = vu;
                    int scaledValue = (int)Math.round((double)(vu * 12) / upperBound);
                    output.sendChannelAftertouch(16 * i + scaledValue, 0);
                }
                if (!hasMotorFaders) continue;
                this.updateFaders(output, i, channel, track);
            }
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        surface = (MCUControlSurface)this.getSurface();
        output = surface.getOutput();
        if (enableVUMeters) {
            int scaledValue;
            int vu = masterTrack.getVuLeft();
            if (vu != this.masterVuValues[0]) {
                this.masterVuValues[0] = vu;
                scaledValue = (int)Math.round((double)(vu * 12) / upperBound);
                output.sendChannelAftertouch(1, scaledValue, 0);
            }
            if ((vu = masterTrack.getVuRight()) != this.masterVuValues[1]) {
                this.masterVuValues[1] = vu;
                scaledValue = (int)Math.round((double)(vu * 12) / upperBound);
                output.sendChannelAftertouch(1, 16 + scaledValue, 0);
            }
        }
        if (hasMotorFaders) {
            int volume;
            int n = volume = surface.isShiftPressed() ? this.model.getTransport().getMetronomeVolume() : masterTrack.getVolume();
            if (volume != this.masterFaderValue) {
                this.masterFaderValue = volume;
                output.sendPitchbend(8, volume % 127, volume / 127);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateFaders(IMidiOutput output, int index, int channel, ITrack track) {
        int value = track.getVolume();
        if (((MCUConfiguration)this.configuration).useFadersAsKnobs()) {
            ModeManager modeManager = ((MCUControlSurface)this.getSurface()).getModeManager();
            if (modeManager.isActiveMode(Modes.MODE_VOLUME)) {
                value = track.getVolume();
            } else if (modeManager.isActiveMode(Modes.MODE_PAN)) {
                value = track.getPan();
            } else if (modeManager.isActiveMode(Modes.MODE_TRACK)) {
                ITrack selectedTrack = this.model.getSelectedTrack();
                if (selectedTrack == null) {
                    value = 0;
                } else {
                    switch (index) {
                        case 0: {
                            value = selectedTrack.getVolume();
                            break;
                        }
                        case 1: {
                            value = selectedTrack.getPan();
                            break;
                        }
                        default: {
                            boolean effectTrackBankActive = this.model.isEffectTrackBankActive();
                            if (index == 2) {
                                if (((MCUConfiguration)this.configuration).isDisplayCrossfader()) {
                                    int crossfadeMode = selectedTrack.getCrossfadeModeAsNumber();
                                    value = crossfadeMode == 2 ? this.valueChanger.getUpperBound() : (crossfadeMode == 1 ? this.valueChanger.getUpperBound() / 2 : 0);
                                    break;
                                }
                                if (effectTrackBankActive) break;
                                value = selectedTrack.getSend(0).getValue();
                                break;
                            }
                            if (effectTrackBankActive) break;
                            value = selectedTrack.getSend(index - (((MCUConfiguration)this.configuration).isDisplayCrossfader() ? 3 : 2)).getValue();
                            break;
                        }
                    }
                }
            } else if (modeManager.isActiveMode(Modes.MODE_SEND1)) {
                value = track.getSend(0).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND2)) {
                value = track.getSend(1).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND3)) {
                value = track.getSend(2).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND4)) {
                value = track.getSend(3).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND5)) {
                value = track.getSend(4).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND6)) {
                value = track.getSend(5).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND7)) {
                value = track.getSend(6).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_SEND8)) {
                value = track.getSend(7).getValue();
            } else if (modeManager.isActiveMode(Modes.MODE_DEVICE_PARAMS)) {
                value = this.model.getCursorDevice().getFXParam(channel).getValue();
            }
        }
        if (value != this.faderValues[channel]) {
            this.faderValues[channel] = value;
            output.sendPitchbend(index, value % 127, value / 127);
        }
    }

    private void updateMode(Integer mode) {
        if (mode == null) {
            return;
        }
        this.updateIndication(mode);
        if (((MCUConfiguration)this.configuration).hasAssignmentDisplay()) {
            ((MCUControlSurface)this.getSurface()).getSegmentDisplay().setAssignmentDisplay(MODE_ACRONYMS.get(mode));
        }
    }

    private void updateIndication(Integer mode) {
        int i;
        ITrackBank tb = this.model.getTrackBank();
        IChannelBank tbe = this.model.getEffectTrackBank();
        boolean isEffect = this.model.isEffectTrackBankActive();
        boolean isPan = Modes.MODE_PAN.equals(mode);
        boolean isTrack = Modes.MODE_TRACK.equals(mode);
        boolean isDevice = Modes.MODE_DEVICE_PARAMS.equals(mode);
        tb.setIndication(!isEffect);
        if (tbe != null) {
            tbe.setIndication(isEffect);
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        ITrack selectedTrack = tb.getSelectedTrack();
        for (i = 0; i < tb.getNumTracks(); ++i) {
            boolean hasTrackSel = selectedTrack != null && selectedTrack.getIndex() == i && isTrack;
            ITrack track = tb.getTrack(i);
            track.setVolumeIndication(!isEffect && (isTrack || hasTrackSel));
            track.setPanIndication(!isEffect && (isPan || hasTrackSel));
            for (int j = 0; j < tb.getNumSends(); ++j) {
                track.getSend(j).setIndication(!isEffect && (mode - Modes.MODE_SEND1 == j || hasTrackSel));
            }
            if (tbe == null) continue;
            ITrack fxTrack = tbe.getTrack(i);
            fxTrack.setVolumeIndication(isEffect);
            fxTrack.setPanIndication(isEffect && isPan);
        }
        for (i = 0; i < cursorDevice.getNumParameters(); ++i) {
            cursorDevice.indicateParameter(i, isDevice);
        }
    }

    private void handleTrackChange(int index, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        ModeManager modeManager = ((MCUControlSurface)this.getSurface()).getModeManager();
        if (modeManager.isActiveMode(Modes.MODE_MASTER)) {
            modeManager.setActiveMode(Modes.MODE_TRACK);
        }
    }

    static {
        MODE_ACRONYMS.put(Modes.MODE_TRACK, "TR");
        MODE_ACRONYMS.put(Modes.MODE_VOLUME, "VL");
        MODE_ACRONYMS.put(Modes.MODE_PAN, "PN");
        MODE_ACRONYMS.put(Modes.MODE_SEND1, "S1");
        MODE_ACRONYMS.put(Modes.MODE_SEND2, "S2");
        MODE_ACRONYMS.put(Modes.MODE_SEND3, "S3");
        MODE_ACRONYMS.put(Modes.MODE_SEND4, "S4");
        MODE_ACRONYMS.put(Modes.MODE_SEND5, "S5");
        MODE_ACRONYMS.put(Modes.MODE_SEND6, "S6");
        MODE_ACRONYMS.put(Modes.MODE_SEND7, "S7");
        MODE_ACRONYMS.put(Modes.MODE_SEND8, "S8");
        MODE_ACRONYMS.put(Modes.MODE_MASTER, "MT");
        MODE_ACRONYMS.put(Modes.MODE_DEVICE_PARAMS, "DC");
        MODE_ACRONYMS.put(Modes.MODE_BROWSER, "BR");
    }
}

