/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mcu;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.IValueChanger;
import java.util.Arrays;

public class MCUConfiguration
extends AbstractConfiguration {
    public static final Integer ZOOM_STATE = 30;
    public static final Integer DISPLAY_MODE_TICKS_OR_TEMPO = 31;
    public static final Integer HAS_DISPLAY1 = 32;
    public static final Integer HAS_DISPLAY2 = 33;
    public static final Integer HAS_SEGMENT_DISPLAY = 34;
    public static final Integer HAS_ASSIGNMENT_DISPLAY = 35;
    public static final Integer HAS_MOTOR_FADERS = 36;
    public static final Integer DISPLAY_TRACK_NAMES = 37;
    public static final Integer USE_VERT_ZOOM_FOR_MODES = 38;
    public static final Integer USE_FADERS_AS_KNOBS = 39;
    private static final Integer TOUCH_CHANNEL = 40;
    public static final int FOOTSWITCH_2_PREV_MODE = 15;
    public static final int FOOTSWITCH_2_NEXT_MODE = 16;
    private static final String DEVICE_SELECT = "<Select a profile>";
    private static final String DEVICE_ICON_PLATFORM_M = "icon Platform M / M+";
    private static final String DEVICE_ICON_QCON_PRO_X = "icon QConPro X";
    private static final String DEVICE_MACKIE_MCU_PRO = "Mackie MCU Pro";
    private static final String DEVICE_ZOOM_R16 = "Zoom R16";
    private static final String[] DEVICE_OPTIONS = new String[]{"<Select a profile>", "icon Platform M / M+", "icon QConPro X", "Mackie MCU Pro", "Zoom R16"};
    private static final String[] ASSIGNABLE_VALUES = new String[]{"Toggle Play", "Toggle Record", "Stop All Clips", "Toggle Clip Overdub", "Undo", "Tap Tempo", "New Button", "Clip Based Looper", "Panel layout arrange", "Panel layout mix", "Panel layout edit", "Add instrument track", "Add audio track", "Add effect track", "Quantize", "Previous mode", "Next mode"};
    private static final String[] ASSIGNABLE_BUTTON_NAMES = new String[]{"Footswitch 1", "Footswitch 2", "F1", "F2", "F3", "F4", "F5"};
    private static final String[] TEMPO_OR_TICKS_OPTIONS = new String[]{"Ticks", "Tempo"};
    private IEnumSetting zoomStateSetting;
    private IEnumSetting tempoOrTicksSetting;
    private IEnumSetting hasDisplay1Setting;
    private IEnumSetting hasDisplay2Setting;
    private IEnumSetting hasSegmentDisplaySetting;
    private IEnumSetting hasAssignmentDisplaySetting;
    private IEnumSetting hasMotorFadersSetting;
    private IEnumSetting displayTrackNamesSetting;
    private IEnumSetting useVertZoomForModesSetting;
    private IEnumSetting useFadersAsKnobsSetting;
    private boolean zoomState;
    private boolean displayTicks;
    private boolean hasDisplay1;
    private boolean hasDisplay2;
    private boolean hasSegmentDisplay;
    private boolean hasAssignmentDisplay;
    private boolean hasMotorFaders;
    private boolean displayTrackNames;
    private boolean useVertZoomForModes;
    private boolean useFadersAsKnobs;
    private boolean touchChannel;
    private int[] assignableFunctions = new int[7];

    public MCUConfiguration(IValueChanger valueChanger) {
        super(valueChanger);
        Arrays.fill(this.assignableFunctions, 0);
    }

    @Override
    public void init(ISettingsUI settingsUI) {
        this.activateHardwareSettings(settingsUI);
        this.activateEnableVUMetersSetting(settingsUI, "Hardware Setup");
        this.activateAssignableSettings(settingsUI);
        this.activateBehaviourOnStopSetting(settingsUI);
        this.activateFlipRecordSetting(settingsUI);
        this.activateQuantizeAmountSetting(settingsUI);
        this.activateDisplayCrossfaderSetting(settingsUI);
        this.activateNewClipLengthSetting(settingsUI);
        this.activateZoomStateSetting(settingsUI);
        this.activateDisplayTempoOrTicksSetting(settingsUI);
        this.activateChannelTouchSetting(settingsUI);
        this.activateBrowserSettings(settingsUI);
    }

    private void activateHardwareSettings(ISettingsUI settingsUI) {
        IEnumSetting profileSetting = settingsUI.getEnumSetting("Profile", "Hardware Setup", DEVICE_OPTIONS, DEVICE_OPTIONS[0]);
        profileSetting.addValueObserver(value -> {
            switch (value) {
                case "icon Platform M / M+": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[0]);
                    this.hasDisplay2Setting.set(ON_OFF_OPTIONS[0]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasAssignmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[1]);
                    this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useVertZoomForModesSetting.set(ON_OFF_OPTIONS[1]);
                    this.useFadersAsKnobsSetting.set(ON_OFF_OPTIONS[0]);
                    this.setVUMetersEnabled(false);
                    break;
                }
                case "icon QConPro X": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[1]);
                    this.hasDisplay2Setting.set(ON_OFF_OPTIONS[1]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[1]);
                    this.hasAssignmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[1]);
                    this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useVertZoomForModesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useFadersAsKnobsSetting.set(ON_OFF_OPTIONS[0]);
                    this.setVUMetersEnabled(true);
                    break;
                }
                case "Mackie MCU Pro": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[1]);
                    this.hasDisplay2Setting.set(ON_OFF_OPTIONS[0]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[1]);
                    this.hasAssignmentDisplaySetting.set(ON_OFF_OPTIONS[1]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[1]);
                    this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[1]);
                    this.useVertZoomForModesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useFadersAsKnobsSetting.set(ON_OFF_OPTIONS[0]);
                    this.setVUMetersEnabled(true);
                    break;
                }
                case "Zoom R16": {
                    this.hasDisplay1Setting.set(ON_OFF_OPTIONS[0]);
                    this.hasDisplay2Setting.set(ON_OFF_OPTIONS[0]);
                    this.hasSegmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasAssignmentDisplaySetting.set(ON_OFF_OPTIONS[0]);
                    this.hasMotorFadersSetting.set(ON_OFF_OPTIONS[0]);
                    this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useVertZoomForModesSetting.set(ON_OFF_OPTIONS[0]);
                    this.useFadersAsKnobsSetting.set(ON_OFF_OPTIONS[1]);
                    this.setVUMetersEnabled(false);
                    break;
                }
                default: {
                    return;
                }
            }
            profileSetting.set(DEVICE_SELECT);
        });
        this.hasDisplay1Setting = settingsUI.getEnumSetting("Has a display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasDisplay1Setting.addValueObserver(value -> {
            this.hasDisplay1 = "On".equals(value);
            this.notifyObservers(HAS_DISPLAY1);
        });
        this.hasDisplay2Setting = settingsUI.getEnumSetting("Has a second display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasDisplay2Setting.addValueObserver(value -> {
            this.hasDisplay2 = "On".equals(value);
            this.notifyObservers(HAS_DISPLAY2);
        });
        this.hasSegmentDisplaySetting = settingsUI.getEnumSetting("Has a position/tempo display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasSegmentDisplaySetting.addValueObserver(value -> {
            this.hasSegmentDisplay = "On".equals(value);
            this.notifyObservers(HAS_SEGMENT_DISPLAY);
        });
        this.hasAssignmentDisplaySetting = settingsUI.getEnumSetting("Has an assignment display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasAssignmentDisplaySetting.addValueObserver(value -> {
            this.hasAssignmentDisplay = "On".equals(value);
            this.notifyObservers(HAS_ASSIGNMENT_DISPLAY);
        });
        this.hasMotorFadersSetting = settingsUI.getEnumSetting("Has motor faders", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.hasMotorFadersSetting.addValueObserver(value -> {
            this.hasMotorFaders = "On".equals(value);
            this.notifyObservers(HAS_MOTOR_FADERS);
        });
        this.displayTrackNamesSetting = settingsUI.getEnumSetting("Display track names in 1st display", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.displayTrackNamesSetting.addValueObserver(value -> {
            this.displayTrackNames = "On".equals(value);
            this.notifyObservers(DISPLAY_TRACK_NAMES);
        });
        this.useVertZoomForModesSetting = settingsUI.getEnumSetting("Use vertical zoom to change tracks", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.useVertZoomForModesSetting.addValueObserver(value -> {
            this.useVertZoomForModes = "On".equals(value);
            this.notifyObservers(USE_VERT_ZOOM_FOR_MODES);
        });
        this.useFadersAsKnobsSetting = settingsUI.getEnumSetting("Use faders like editing knobs", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.useFadersAsKnobsSetting.addValueObserver(value -> {
            this.useFadersAsKnobs = "On".equals(value);
            this.notifyObservers(USE_FADERS_AS_KNOBS);
        });
    }

    private void activateAssignableSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.assignableFunctions.length; ++i) {
            int pos = i;
            IEnumSetting setting = settingsUI.getEnumSetting(ASSIGNABLE_BUTTON_NAMES[i], "Assignable buttons", ASSIGNABLE_VALUES, ASSIGNABLE_VALUES[6]);
            setting.addValueObserver(value -> {
                this.assignableFunctions[pos] = MCUConfiguration.lookupIndex(ASSIGNABLE_VALUES, value);
            });
        }
    }

    protected void activateZoomStateSetting(ISettingsUI settingsUI) {
        this.zoomStateSetting = settingsUI.getEnumSetting("Zoom", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        this.zoomStateSetting.addValueObserver(value -> {
            this.zoomState = "On".equals(value);
            this.notifyObservers(ZOOM_STATE);
        });
    }

    protected void activateChannelTouchSetting(ISettingsUI settingsUI) {
        IEnumSetting touchChannelSetting = settingsUI.getEnumSetting("Select Channel on Fader Touch", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        touchChannelSetting.addValueObserver(value -> {
            this.touchChannel = "On".equals(value);
            this.notifyObservers(TOUCH_CHANNEL);
        });
    }

    protected void activateDisplayTempoOrTicksSetting(ISettingsUI settingsUI) {
        this.tempoOrTicksSetting = settingsUI.getEnumSetting("Display tempo or ticks", "Workflow", TEMPO_OR_TICKS_OPTIONS, TEMPO_OR_TICKS_OPTIONS[0]);
        this.tempoOrTicksSetting.addValueObserver(value -> {
            this.displayTicks = TEMPO_OR_TICKS_OPTIONS[0].equals(value);
            this.notifyObservers(DISPLAY_MODE_TICKS_OR_TEMPO);
        });
    }

    public boolean isZoomState() {
        return this.zoomState;
    }

    public void toggleZoomState() {
        this.zoomStateSetting.set(this.zoomState ? ON_OFF_OPTIONS[0] : ON_OFF_OPTIONS[1]);
    }

    public boolean isDisplayTicks() {
        return this.displayTicks;
    }

    public void toggleDisplayTicks() {
        this.tempoOrTicksSetting.set(this.displayTicks ? TEMPO_OR_TICKS_OPTIONS[1] : TEMPO_OR_TICKS_OPTIONS[0]);
    }

    public boolean hasDisplay1() {
        return this.hasDisplay1;
    }

    public boolean hasDisplay2() {
        return this.hasDisplay2;
    }

    public boolean hasSegmentDisplay() {
        return this.hasSegmentDisplay;
    }

    public boolean hasAssignmentDisplay() {
        return this.hasAssignmentDisplay;
    }

    public boolean hasMotorFaders() {
        return this.hasMotorFaders;
    }

    public boolean isDisplayTrackNames() {
        return this.displayTrackNames;
    }

    public void toggleDisplayTrackNames() {
        this.displayTrackNamesSetting.set(ON_OFF_OPTIONS[this.displayTrackNames ? 0 : 1]);
    }

    public boolean useVertZoomForModes() {
        return this.useVertZoomForModes;
    }

    public boolean useFadersAsKnobs() {
        return this.useFadersAsKnobs;
    }

    public int getAssignable(int index) {
        return this.assignableFunctions[index];
    }

    public boolean isTouchChannel() {
        return this.touchChannel;
    }
}

