/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.ButtonEvent;

public class VolumeView
extends AbstractFaderView {
    public VolumeView(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).setVolume(value);
    }

    @Override
    public void drawGrid() {
        ColorManager cm = this.model.getColorManager();
        IChannelBank tb = this.model.getCurrentTrackBank();
        IMidiOutput output = ((LaunchpadControlSurface)this.surface).getOutput();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            int color = cm.getColor(DAWColors.getColorIndex(track.getColor()));
            if (this.trackColors[i] != color) {
                this.trackColors[i] = color;
                this.setupFader(i);
            }
            output.sendCC(21 + i, track.getVolume());
        }
    }

    @Override
    public void updateSceneButtons() {
        ColorManager cm = this.model.getColorManager();
        IMasterTrack track = this.model.getMasterTrack();
        int sceneMax = 9 * track.getVolume() / this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            int color = cm.getColor(DAWColors.getColorIndex(track.getColor()));
            ((LaunchpadControlSurface)this.surface).setButton(19 + 10 * i, i < sceneMax ? color : 0);
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IMasterTrack track = this.model.getMasterTrack();
        track.setVolume(Math.min(127, (7 - scene) * this.model.getValueChanger().getUpperBound() / 7));
    }
}

