/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.command.Commands;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.View;

public class ShiftView
extends AbstractView<LaunchpadControlSurface, LaunchpadConfiguration>
implements SceneView {
    public ShiftView(LaunchpadControlSurface surface, IModel model) {
        super("Shift", surface, model);
    }

    @Override
    public void onActivate() {
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPrgMode();
        super.onActivate();
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        if (((LaunchpadControlSurface)this.surface).isPro()) {
            for (int i = 36; i < 97; ++i) {
                padGrid.light(i, 0);
            }
        } else {
            int i;
            padGrid.light(36, 6);
            padGrid.light(37, 22);
            padGrid.light(38, 14);
            padGrid.light(39, 46);
            padGrid.light(40, 34);
            padGrid.light(41, 38);
            padGrid.light(42, 50);
            padGrid.light(43, 4);
            padGrid.light(44, 6);
            padGrid.light(45, 4);
            for (i = 46; i < 51; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(51, 6);
            padGrid.light(52, 22);
            padGrid.light(53, 24);
            for (i = 54; i < 60; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(60, 22);
            padGrid.light(61, 24);
            for (i = 62; i < 68; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(68, 22);
            padGrid.light(69, 0);
            for (i = 70; i < 76; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(76, 22);
            padGrid.light(77, 0);
            for (i = 78; i < 84; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(84, 22);
            padGrid.light(85, 24);
            for (i = 86; i < 92; ++i) {
                padGrid.light(i, 0);
            }
            padGrid.light(92, 22);
            padGrid.light(93, 24);
            for (i = 94; i < 97; ++i) {
                padGrid.light(i, 0);
            }
        }
        padGrid.light(97, 22);
        padGrid.light(98, 24);
        padGrid.light(99, 32);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!((LaunchpadControlSurface)this.surface).isPro() && this.handleControlModes(note, velocity)) {
            return;
        }
        if (velocity > 0) {
            this.handleFunctions(note);
        }
    }

    @Override
    public void updateSceneButtons() {
        boolean isPro = ((LaunchpadControlSurface)this.surface).isPro();
        ((LaunchpadControlSurface)this.surface).setButton(89, isPro ? 0 : 34);
        ((LaunchpadControlSurface)this.surface).setButton(79, isPro ? 0 : 38);
        ((LaunchpadControlSurface)this.surface).setButton(69, isPro ? 0 : 50);
        ((LaunchpadControlSurface)this.surface).setButton(59, isPro ? 0 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(49, isPro ? 0 : 4);
        ((LaunchpadControlSurface)this.surface).setButton(39, isPro ? 0 : 14);
        ((LaunchpadControlSurface)this.surface).setButton(29, isPro ? 0 : 46);
        ((LaunchpadControlSurface)this.surface).setButton(19, isPro ? 0 : 6);
    }

    private boolean handleControlModes(int note, int velocity) {
        ButtonEvent event = velocity == 0 ? ButtonEvent.UP : ButtonEvent.DOWN;
        View view = ((LaunchpadControlSurface)this.surface).getViewManager().getActiveView();
        switch (note) {
            case 36: {
                view.getTriggerCommand(Commands.COMMAND_REC_ARM).execute(event);
                break;
            }
            case 37: {
                view.getTriggerCommand(Commands.COMMAND_TRACK).execute(event);
                break;
            }
            case 38: {
                view.getTriggerCommand(Commands.COMMAND_MUTE).execute(event);
                break;
            }
            case 39: {
                view.getTriggerCommand(Commands.COMMAND_SOLO).execute(event);
                break;
            }
            case 40: {
                view.getTriggerCommand(Commands.COMMAND_VOLUME).execute(event);
                break;
            }
            case 41: {
                view.getTriggerCommand(Commands.COMMAND_PAN_SEND).execute(event);
                break;
            }
            case 42: {
                view.getTriggerCommand(Commands.COMMAND_SENDS).execute(event);
                break;
            }
            case 43: {
                view.getTriggerCommand(Commands.COMMAND_STOP_CLIP).execute(event);
                break;
            }
            default: {
                return false;
            }
        }
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        if (modeManager.getPreviousModeId() == modeManager.getActiveModeId()) {
            modeManager.setActiveMode(null);
        }
        return true;
    }

    private void handleFunctions(int note) {
        View view = ((LaunchpadControlSurface)this.surface).getViewManager().getActiveView();
        switch (note) {
            case 97: {
                this.model.getApplication().addInstrumentTrack();
                return;
            }
            case 98: {
                this.model.getApplication().addAudioTrack();
                return;
            }
            case 99: {
                this.model.getApplication().addEffectTrack();
                return;
            }
        }
        if (((LaunchpadControlSurface)this.surface).isPro()) {
            return;
        }
        switch (note) {
            case 92: {
                view.getTriggerCommand(Commands.COMMAND_METRONOME).executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 93: {
                view.getTriggerCommand(Commands.COMMAND_METRONOME).executeShifted(ButtonEvent.DOWN);
                break;
            }
            case 84: {
                view.getTriggerCommand(Commands.COMMAND_UNDO).executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 85: {
                view.getTriggerCommand(Commands.COMMAND_UNDO).executeShifted(ButtonEvent.DOWN);
                break;
            }
            case 76: {
                view.getTriggerCommand(Commands.COMMAND_DELETE).executeNormal(ButtonEvent.UP);
                break;
            }
            case 68: {
                view.getTriggerCommand(Commands.COMMAND_QUANTIZE).executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 60: {
                view.getTriggerCommand(Commands.COMMAND_DUPLICATE).executeNormal(ButtonEvent.DOWN);
                break;
            }
            case 61: {
                view.getTriggerCommand(Commands.COMMAND_DUPLICATE).executeShifted(ButtonEvent.DOWN);
                break;
            }
            case 52: {
                view.getTriggerCommand(Commands.COMMAND_NEW).execute(ButtonEvent.DOWN);
                break;
            }
            case 53: {
                view.getTriggerCommand(Commands.COMMAND_PLAY).execute(ButtonEvent.DOWN);
                break;
            }
            case 44: {
                view.getTriggerCommand(Commands.COMMAND_RECORD).executeNormal(ButtonEvent.UP);
                break;
            }
            case 45: {
                view.getTriggerCommand(Commands.COMMAND_RECORD).executeShifted(ButtonEvent.UP);
                break;
            }
            case 51: {
                this.model.getCurrentTrackBank().stop();
            }
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (((LaunchpadControlSurface)this.surface).isPro()) {
            return;
        }
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (scene) {
            case 0: {
                this.handleControlModes(40, 127);
                break;
            }
            case 1: {
                this.handleControlModes(41, 127);
                break;
            }
            case 2: {
                this.handleControlModes(42, 127);
                break;
            }
            case 3: {
                this.handleControlModes(37, 127);
                break;
            }
            case 4: {
                this.handleControlModes(43, 127);
                break;
            }
            case 5: {
                this.handleControlModes(38, 127);
                break;
            }
            case 6: {
                this.handleControlModes(39, 127);
                break;
            }
            case 7: {
                this.handleControlModes(36, 127);
            }
        }
    }
}

