/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.mode.Modes;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.SessionColor;
import de.mossgrabers.framework.view.ViewManager;

public class SessionView
extends AbstractSessionView<LaunchpadControlSurface, LaunchpadConfiguration> {
    protected boolean isTemporary;

    public SessionView(LaunchpadControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 8, true);
        SessionColor isRecording = new SessionColor(5, 5, false);
        SessionColor isRecordingQueued = new SessionColor(5, 0, true);
        SessionColor isPlaying = new SessionColor(22, 22, false);
        SessionColor isPlayingQueued = new SessionColor(22, 0, true);
        SessionColor hasContent = new SessionColor(10, -1, false);
        SessionColor noContent = new SessionColor(0, -1, false);
        SessionColor recArmed = new SessionColor(7, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed);
    }

    @Override
    public void onActivate() {
        this.switchLaunchpadMode();
        super.onActivate();
        ((LaunchpadControlSurface)this.surface).scheduleTask(this::delayedUpdateArrowButtons, 150L);
    }

    protected void delayedUpdateArrowButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSessionButton(), 18);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getNoteButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDeviceButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUserButton(), 1);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean isNotRow1;
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        Integer activeModeId = modeManager.getActiveModeId();
        boolean bl = isNotRow1 = note >= 44;
        if (activeModeId == null || isNotRow1) {
            if (((LaunchpadControlSurface)this.surface).isShiftPressed()) {
                this.onGridNoteBankSelection(note, velocity, isNotRow1);
                return;
            }
            int n = note - (activeModeId != null ? 8 : 0);
            int index = n - 36;
            int t = index % this.columns;
            if (((LaunchpadControlSurface)this.surface).isPressed(30)) {
                ((LaunchpadControlSurface)this.surface).setButtonConsumed(30);
                IChannelBank tb = this.model.getCurrentTrackBank();
                ITrack track = tb.getTrack(t);
                if (track.doesExist()) {
                    int s = this.rows - 1 - index / this.columns;
                    track.getSlot(s).duplicate();
                }
                return;
            }
            super.onGridNote(n, velocity);
            return;
        }
        if (velocity != 0) {
            this.handleFirstRowModes(note, modeManager);
        }
    }

    @Override
    public void drawGrid() {
        Integer controlMode = ((LaunchpadControlSurface)this.surface).getModeManager().getActiveModeId();
        boolean isOff = controlMode == null;
        boolean flip = ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).isFlipSession();
        this.rows = isOff || flip ? 8 : 7;
        this.columns = isOff || !flip ? 8 : 7;
        super.drawGrid();
        if (isOff) {
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        PadGrid pads = ((LaunchpadControlSurface)this.surface).getPadGrid();
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        for (int x = 0; x < this.columns; ++x) {
            ITrack track = tb.getTrack(x);
            boolean exists = track.doesExist();
            if (modeManager.isActiveMode(Modes.MODE_REC_ARM)) {
                pads.lightEx(x, 7, exists ? (track.isRecArm() ? 5 : 7) : 0);
                continue;
            }
            if (modeManager.isActiveMode(Modes.MODE_TRACK_SELECT)) {
                pads.lightEx(x, 7, exists ? (track.isSelected() ? 21 : 23) : 0);
                continue;
            }
            if (modeManager.isActiveMode(Modes.MODE_MUTE)) {
                pads.lightEx(x, 7, exists ? (track.isMute() ? 13 : 15) : 0);
                continue;
            }
            if (modeManager.isActiveMode(Modes.MODE_SOLO)) {
                pads.lightEx(x, 7, exists ? (track.isSolo() ? 45 : 47) : 0);
                continue;
            }
            if (!modeManager.isActiveMode(Modes.MODE_STOP_CLIP)) continue;
            pads.lightEx(x, 7, exists ? 4 : 0);
        }
    }

    public void switchLaunchpadMode() {
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPrgMode();
    }

    @Override
    public void updateSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(89, 22);
        ((LaunchpadControlSurface)this.surface).setButton(79, 22);
        ((LaunchpadControlSurface)this.surface).setButton(69, 22);
        ((LaunchpadControlSurface)this.surface).setButton(59, 22);
        ((LaunchpadControlSurface)this.surface).setButton(49, 22);
        ((LaunchpadControlSurface)this.surface).setButton(39, 22);
        ((LaunchpadControlSurface)this.surface).setButton(29, 22);
        ((LaunchpadControlSurface)this.surface).setButton(19, 22);
    }

    public void onSession(ButtonEvent event) {
        switch (event) {
            case LONG: {
                this.isTemporary = true;
                break;
            }
            case UP: {
                if (!this.isTemporary) {
                    return;
                }
                this.isTemporary = false;
                ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
                ITrack selectedTrack = this.model.getSelectedTrack();
                if (selectedTrack == null) {
                    return;
                }
                Integer viewId = viewManager.getPreferredView(selectedTrack.getPosition());
                viewManager.setActiveView(viewId == null ? Views.VIEW_PLAY : viewId);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void onGridNoteBankSelection(int note, int velocity, boolean isOffset) {
        int padsX;
        if (velocity == 0) {
            return;
        }
        int n = isOffset ? note : note - 8;
        int index = n - 36;
        int x = index % this.columns;
        int y = this.rows - 1 - index / this.columns;
        IChannelBank tb = this.model.getCurrentTrackBank();
        int trackPosition = tb.getTrack(0).getPosition() / tb.getNumTracks();
        int scenePosition = tb.getScenePosition() / tb.getNumScenes();
        boolean flip = ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).isFlipSession();
        int selX = flip ? scenePosition : trackPosition;
        int selY = flip ? trackPosition : scenePosition;
        int n2 = padsX = flip ? this.rows : this.columns;
        int padsY = flip ? this.columns : (isOffset ? this.rows + 1 : this.rows);
        int offsetX = selX / padsX * padsX;
        int offsetY = selY / padsY * padsY;
        tb.scrollToChannel(offsetX * tb.getNumTracks() + (flip ? y : x) * padsX);
        tb.scrollToScene(offsetY * tb.getNumScenes() + (flip ? x : y) * padsY);
    }

    private void handleFirstRowModes(int note, ModeManager modeManager) {
        int index = note - 36;
        ITrack track = this.model.getCurrentTrackBank().getTrack(index);
        if (((LaunchpadControlSurface)this.surface).isPressed(30)) {
            ((LaunchpadControlSurface)this.surface).setButtonConsumed(30);
            track.duplicate();
            return;
        }
        if (modeManager.isActiveMode(Modes.MODE_REC_ARM)) {
            track.toggleRecArm();
        } else if (modeManager.isActiveMode(Modes.MODE_TRACK_SELECT)) {
            this.selectTrack(index);
        } else if (modeManager.isActiveMode(Modes.MODE_MUTE)) {
            track.toggleMute();
        } else if (modeManager.isActiveMode(Modes.MODE_SOLO)) {
            track.toggleSolo();
        } else if (modeManager.isActiveMode(Modes.MODE_STOP_CLIP)) {
            track.stop();
        }
    }
}

