/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SendsView
extends AbstractFaderView {
    private int selectedSend;

    public SendsView(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        if (!this.model.isEffectTrackBankActive()) {
            this.model.getTrackBank().getTrack(index).getSend(this.selectedSend).setValue(value);
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.selectedSend = scene;
        }
    }

    @Override
    public void drawGrid() {
        ColorManager cm = this.model.getColorManager();
        IChannelBank tb = this.model.getCurrentTrackBank();
        IMidiOutput output = ((LaunchpadControlSurface)this.surface).getOutput();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            ISend send = track.getSend(this.selectedSend);
            int color = cm.getColor(DAWColors.getColorIndex(track.getColor()));
            if (this.trackColors[i] != color) {
                this.trackColors[i] = color;
                this.setupFader(i);
            }
            output.sendCC(21 + i, send.getValue());
        }
    }

    @Override
    public void updateSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(89, this.selectedSend == 0 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(79, this.selectedSend == 1 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(69, this.selectedSend == 2 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(59, this.selectedSend == 3 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(49, this.selectedSend == 4 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(39, this.selectedSend == 5 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(29, this.selectedSend == 6 ? 50 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(19, this.selectedSend == 7 ? 50 : 0);
    }

    public int getSelectedSend() {
        return this.selectedSend;
    }
}

