/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.view.AbstractRaindropsView;

public class RaindropsView
extends AbstractRaindropsView<LaunchpadControlSurface, LaunchpadConfiguration> {
    public RaindropsView(LaunchpadControlSurface surface, IModel model) {
        super("Raindrops", surface, model, true);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPrgMode();
        ((LaunchpadControlSurface)this.surface).scheduleTask(this::delayedUpdateArrowButtons, 150L);
    }

    private void delayedUpdateArrowButtons() {
        boolean hasClips = this.model.getHost().hasClips();
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSessionButton(), hasClips ? 1 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getNoteButton(), 22);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDeviceButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUserButton(), 1);
    }

    @Override
    public void updateSceneButtons() {
        for (int i = 0; i < 8; ++i) {
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSceneButton(i), i == 7 - this.selectedIndex ? 14 : 22);
        }
    }
}

