/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.display.Display;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.SceneView;
import java.util.Arrays;

public class PlayView
extends AbstractPlayView<LaunchpadControlSurface, LaunchpadConfiguration>
implements SceneView {
    public PlayView(LaunchpadControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, LaunchpadControlSurface surface, IModel model) {
        super(name, surface, model, true);
        Object configuration = ((LaunchpadControlSurface)this.surface).getConfiguration();
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, this::initMaxVelocity);
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, this::initMaxVelocity);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.initMaxVelocity();
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPrgMode();
        ((LaunchpadControlSurface)this.surface).scheduleTask(this::delayedUpdateArrowButtons, 150L);
    }

    private void delayedUpdateArrowButtons() {
        boolean hasClips = this.model.getHost().hasClips();
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSessionButton(), hasClips ? 1 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getNoteButton(), 41);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDeviceButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUserButton(), 1);
    }

    @Override
    public void updateSceneButtons() {
        if (this.model.canSelectedTrackHoldNotes()) {
            ((LaunchpadControlSurface)this.surface).setButton(89, 41);
            ((LaunchpadControlSurface)this.surface).setButton(79, 41);
            ((LaunchpadControlSurface)this.surface).setButton(69, 0);
            ((LaunchpadControlSurface)this.surface).setButton(59, 0);
            ((LaunchpadControlSurface)this.surface).setButton(49, 0);
            ((LaunchpadControlSurface)this.surface).setButton(39, 3);
            ((LaunchpadControlSurface)this.surface).setButton(29, 41);
            ((LaunchpadControlSurface)this.surface).setButton(19, 41);
        } else {
            ((LaunchpadControlSurface)this.surface).setButton(89, 0);
            ((LaunchpadControlSurface)this.surface).setButton(79, 0);
            ((LaunchpadControlSurface)this.surface).setButton(69, 0);
            ((LaunchpadControlSurface)this.surface).setButton(59, 0);
            ((LaunchpadControlSurface)this.surface).setButton(49, 0);
            ((LaunchpadControlSurface)this.surface).setButton(39, 0);
            ((LaunchpadControlSurface)this.surface).setButton(29, 0);
            ((LaunchpadControlSurface)this.surface).setButton(19, 0);
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        Display display = ((LaunchpadControlSurface)this.surface).getDisplay();
        switch (scene) {
            case 0: {
                this.scales.nextScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case 1: {
                this.scales.prevScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case 5: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                display.notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case 6: {
                this.scales.setScaleOffset(this.scales.getScaleOffset() + 1);
                String name = Scales.BASES[this.scales.getScaleOffset()];
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
            case 7: {
                this.scales.setScaleOffset(this.scales.getScaleOffset() - 1);
                String name = Scales.BASES[this.scales.getScaleOffset()];
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
        }
        this.updateNoteMapping();
    }

    private void initMaxVelocity() {
        int[] maxVelocity = new int[128];
        LaunchpadConfiguration config = (LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration();
        Arrays.fill(maxVelocity, config.getFixedAccentValue());
        maxVelocity[0] = 0;
        ((LaunchpadControlSurface)this.surface).setVelocityTranslationTable(config.isAccentActive() ? maxVelocity : this.defaultVelocity);
    }
}

