/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class PanView
extends AbstractFaderView {
    public PanView(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.model.getCurrentTrackBank().getTrack(index).setPan(value);
    }

    @Override
    public void switchLaunchpadMode() {
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPanMode();
    }

    @Override
    public void drawGrid() {
        ColorManager cm = this.model.getColorManager();
        IChannelBank tb = this.model.getCurrentTrackBank();
        IMidiOutput output = ((LaunchpadControlSurface)this.surface).getOutput();
        for (int i = 0; i < 8; ++i) {
            ITrack track = tb.getTrack(i);
            int color = cm.getColor(DAWColors.getColorIndex(track.getColor()));
            if (this.trackColors[i] != color) {
                this.trackColors[i] = color;
                this.setupFader(i);
            }
            output.sendCC(21 + i, track.doesExist() ? track.getPan() : 64);
        }
    }

    @Override
    public void setupFader(int index) {
        ITrack track = this.model.getCurrentTrackBank().getTrack(index);
        ((LaunchpadControlSurface)this.surface).setupPanFader(index, this.model.getColorManager().getColor(DAWColors.getColorIndex(track.getColor())));
    }
}

