/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.daw.IChannelBank;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrumView;

public abstract class DrumViewBase
extends AbstractDrumView<LaunchpadControlSurface, LaunchpadConfiguration> {
    protected int soundOffset;

    public DrumViewBase(String name, LaunchpadControlSurface surface, IModel model, int numSequencerLines, int numPlayLines) {
        super(name, surface, model, numSequencerLines, numPlayLines);
    }

    @Override
    public void onScene(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        if (!((LaunchpadControlSurface)this.surface).isShiftPressed()) {
            super.onScene(index, event);
            return;
        }
        IChannelBank tb = this.model.getCurrentTrackBank();
        ITrack selectedTrack = tb.getSelectedTrack();
        if (selectedTrack != null) {
            this.onLowerScene(index);
        }
    }

    protected void onLowerScene(int index) {
    }

    @Override
    public void updateSceneButtons() {
        if (((LaunchpadControlSurface)this.surface).isShiftPressed()) {
            for (int i = 0; i < 4; ++i) {
                ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSceneButton(i), 0);
            }
            this.updateLowerSceneButtons();
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int sceneButton = ((LaunchpadControlSurface)this.surface).getSceneButton(i);
            ((LaunchpadControlSurface)this.surface).setButton(sceneButton, i == 7 - this.selectedIndex ? 14 : 22);
        }
    }

    protected void updateLowerSceneButtons() {
        for (int i = 4; i < 8; ++i) {
            ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSceneButton(i), 0);
        }
    }
}

