/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.DrumViewBase;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;

public class DrumView8
extends DrumViewBase {
    private static final int NUM_DISPLAY_COLS = 8;

    public DrumView8(LaunchpadControlSurface surface, IModel model) {
        super("Drum 8", surface, model, 1, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int sound = y + this.soundOffset;
        int col = x;
        this.getClip().toggleStep(col, this.offsetY + this.selectedPad + sound, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        ICursorClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % 8 : -1;
        for (int sound = 0; sound < 8; ++sound) {
            for (int col = 0; col < 8; ++col) {
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad + sound + this.soundOffset);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                padGrid.lightEx(x, 7 - (y += sound), isSet > 0 ? (hilite ? 23 : 45) : (hilite ? 21 : 0));
            }
        }
    }

    @Override
    public void updateNoteMapping() {
        ((LaunchpadControlSurface)this.surface).setKeyTranslationTable(this.scales.translateMatrixToGrid(Scales.getEmptyMatrix()));
    }

    @Override
    protected void updateLowerSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(19, this.soundOffset == 0 ? 14 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(29, this.soundOffset == 8 ? 14 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(39, 0);
        ((LaunchpadControlSurface)this.surface).setButton(49, 0);
    }

    @Override
    protected void onLowerScene(int index) {
        if (index < 6) {
            return;
        }
        this.soundOffset = index == 7 ? 0 : 8;
        ((LaunchpadControlSurface)this.surface).getDisplay().notify("Offset: " + this.soundOffset);
    }
}

