/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.DrumViewBase;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.ICursorClip;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;

public class DrumView4
extends DrumViewBase {
    private static final int NUM_DISPLAY_COLS = 16;

    public DrumView4(LaunchpadControlSurface surface, IModel model) {
        super("Drum 4", surface, model, 2, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int sound = y % 4 + this.soundOffset;
        int col = 8 * (1 - y / 4) + x;
        this.getClip().toggleStep(col, this.offsetY + this.selectedPad + sound, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
    }

    @Override
    public void drawGrid() {
        PadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        ICursorClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % 16 : -1;
        for (int sound = 0; sound < 4; ++sound) {
            for (int col = 0; col < 16; ++col) {
                int isSet = clip.getStep(col, this.offsetY + this.selectedPad + sound + this.soundOffset);
                boolean hilite = col == hiStep;
                int x = col % 8;
                int y = col / 8;
                if (col < 8) {
                    y += 5;
                }
                padGrid.lightEx(x, 8 - (y += sound), isSet > 0 ? (hilite ? 23 : 45) : (hilite ? 21 : 0));
            }
        }
    }

    @Override
    public void updateNoteMapping() {
        ((LaunchpadControlSurface)this.surface).setKeyTranslationTable(this.scales.translateMatrixToGrid(Scales.getEmptyMatrix()));
    }

    @Override
    protected void updateLowerSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(19, this.soundOffset == 0 ? 14 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(29, this.soundOffset == 4 ? 14 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(39, this.soundOffset == 8 ? 14 : 22);
        ((LaunchpadControlSurface)this.surface).setButton(49, this.soundOffset == 12 ? 14 : 22);
    }

    @Override
    protected void onLowerScene(int index) {
        this.soundOffset = 4 * (7 - index);
        ((LaunchpadControlSurface)this.surface).getDisplay().notify("Offset: " + this.soundOffset);
    }
}

