/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadColors;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.daw.ICursorDevice;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;

public class DeviceView
extends AbstractFaderView {
    private ICursorDevice cursorDevice;

    public DeviceView(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
        this.cursorDevice = this.model.getCursorDevice();
    }

    @Override
    public void updateNoteMapping() {
    }

    @Override
    protected void delayedUpdateArrowButtons() {
        boolean hasClips = this.model.getHost().hasClips();
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSessionButton(), hasClips ? 1 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getNoteButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDeviceButton(), 10);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUserButton(), 1);
    }

    @Override
    public void setupFader(int index) {
        ((LaunchpadControlSurface)this.surface).setupFader(index, LaunchpadColors.DAW_INDICATOR_COLORS[index]);
    }

    @Override
    public void onValueKnob(int index, int value) {
        this.cursorDevice.setParameter(index, value);
    }

    @Override
    public void drawGrid() {
        for (int i = 0; i < 8; ++i) {
            IParameter param = this.cursorDevice.getFXParam(i);
            ((LaunchpadControlSurface)this.surface).getOutput().sendCC(21 + i, param.getValue());
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
        if (event == ButtonEvent.DOWN && scene == 0) {
            this.model.getCursorDevice().toggleWindowOpen();
        }
    }

    @Override
    public void updateSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(89, 10);
        ((LaunchpadControlSurface)this.surface).setButton(79, 0);
        ((LaunchpadControlSurface)this.surface).setButton(69, 0);
        ((LaunchpadControlSurface)this.surface).setButton(59, 0);
        ((LaunchpadControlSurface)this.surface).setButton(49, 0);
        ((LaunchpadControlSurface)this.surface).setButton(39, 0);
        ((LaunchpadControlSurface)this.surface).setButton(29, 0);
        ((LaunchpadControlSurface)this.surface).setButton(19, 0);
    }
}

