/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.Views;
import de.mossgrabers.framework.controller.grid.PadGrid;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractView;
import de.mossgrabers.framework.view.SceneView;
import de.mossgrabers.framework.view.ViewManager;

public class BrowserView
extends AbstractView<LaunchpadControlSurface, LaunchpadConfiguration>
implements SceneView {
    private static final int[] COLUMN_ORDER = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] COLUMN_COLORS = new int[]{3, 2, 1, 4, 26, 42, 0, 14};

    public BrowserView(LaunchpadControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onActivate() {
        ((LaunchpadControlSurface)this.surface).setLaunchpadToPrgMode();
        super.onActivate();
        ((LaunchpadControlSurface)this.surface).scheduleTask(this::delayedUpdateArrowButtons, 150L);
    }

    private void delayedUpdateArrowButtons() {
        boolean hasClips = this.model.getHost().hasClips();
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getSessionButton(), hasClips ? 1 : 0);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getNoteButton(), 1);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getDeviceButton(), 30);
        ((LaunchpadControlSurface)this.surface).setButton(((LaunchpadControlSurface)this.surface).getUserButton(), 1);
    }

    @Override
    public void drawGrid() {
        int i;
        PadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        padGrid.light(36, 6);
        padGrid.light(37, 0);
        for (i = 38; i < 42; ++i) {
            padGrid.light(i, 51);
        }
        padGrid.light(42, 0);
        padGrid.light(43, 21);
        for (i = 44; i < 52; ++i) {
            padGrid.light(i, 0);
        }
        for (i = 52; i < 60; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 52]);
        }
        for (i = 60; i < 68; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 60]);
        }
        for (i = 68; i < 76; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 68]);
        }
        for (i = 76; i < 84; ++i) {
            padGrid.light(i, COLUMN_COLORS[i - 76]);
        }
        for (i = 84; i < 100; ++i) {
            padGrid.light(i, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
            if (viewManager.isActiveView(Views.VIEW_BROWSER)) {
                viewManager.restoreView();
            }
            return;
        }
        switch (note) {
            case 36: {
                if (velocity == 0) {
                    return;
                }
                this.model.getBrowser().stopBrowsing(false);
                ((LaunchpadControlSurface)this.surface).getViewManager().restoreView();
                break;
            }
            case 43: {
                if (velocity == 0) {
                    return;
                }
                this.model.getBrowser().stopBrowsing(true);
                ((LaunchpadControlSurface)this.surface).getViewManager().restoreView();
                break;
            }
            case 38: {
                ((LaunchpadControlSurface)this.surface).sendMidiEvent(144, 48, velocity);
                break;
            }
            case 39: {
                ((LaunchpadControlSurface)this.surface).sendMidiEvent(144, 60, velocity);
                break;
            }
            case 40: {
                ((LaunchpadControlSurface)this.surface).sendMidiEvent(144, 72, velocity);
                break;
            }
            case 41: {
                ((LaunchpadControlSurface)this.surface).sendMidiEvent(144, 84, velocity);
            }
        }
        if (velocity == 0) {
            return;
        }
        if (note >= 52 && note < 84) {
            int n = note - 52;
            int row = n / 8;
            int col = n % 8;
            switch (col) {
                case 6: {
                    return;
                }
                case 7: {
                    if (row == 0) {
                        browser.selectNextResult();
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextResult();
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousResult();
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousResult();
                    break;
                }
                default: {
                    if (row == 0) {
                        browser.selectNextFilterItem(COLUMN_ORDER[col]);
                        break;
                    }
                    if (row == 1) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectNextFilterItem(COLUMN_ORDER[col]);
                        }
                        break;
                    }
                    if (row == 2) {
                        for (int i = 0; i < 8; ++i) {
                            browser.selectPreviousFilterItem(COLUMN_ORDER[col]);
                        }
                        break;
                    }
                    if (row != 3) break;
                    browser.selectPreviousFilterItem(COLUMN_ORDER[col]);
                }
            }
            return;
        }
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
    }

    @Override
    public void updateSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(89, 0);
        ((LaunchpadControlSurface)this.surface).setButton(79, 0);
        ((LaunchpadControlSurface)this.surface).setButton(69, 0);
        ((LaunchpadControlSurface)this.surface).setButton(59, 0);
        ((LaunchpadControlSurface)this.surface).setButton(49, 0);
        ((LaunchpadControlSurface)this.surface).setButton(39, 0);
        ((LaunchpadControlSurface)this.surface).setButton(29, 0);
        ((LaunchpadControlSurface)this.surface).setButton(19, 0);
    }
}

