/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.view;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.launchpad.view.SessionView;
import de.mossgrabers.framework.daw.DAWColors;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class AbstractFaderView
extends SessionView {
    protected final int[] trackColors = new int[8];

    public AbstractFaderView(LaunchpadControlSurface surface, IModel model) {
        super(surface, model);
    }

    public abstract void onValueKnob(int var1, int var2);

    @Override
    public void updateNoteMapping() {
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    @Override
    public void onScene(int scene, ButtonEvent event) {
    }

    @Override
    public void onActivate() {
        super.onActivate();
        for (int i = 0; i < 8; ++i) {
            this.setupFader(i);
        }
    }

    @Override
    public void switchLaunchpadMode() {
        ((LaunchpadControlSurface)this.surface).setLaunchpadToFaderMode();
    }

    @Override
    public void updateSceneButtons() {
        ((LaunchpadControlSurface)this.surface).setButton(89, 0);
        ((LaunchpadControlSurface)this.surface).setButton(79, 0);
        ((LaunchpadControlSurface)this.surface).setButton(69, 0);
        ((LaunchpadControlSurface)this.surface).setButton(59, 0);
        ((LaunchpadControlSurface)this.surface).setButton(49, 0);
        ((LaunchpadControlSurface)this.surface).setButton(39, 0);
        ((LaunchpadControlSurface)this.surface).setButton(29, 0);
        ((LaunchpadControlSurface)this.surface).setButton(19, 0);
    }

    public void setupFader(int index) {
        ITrack track = this.model.getCurrentTrackBank().getTrack(index);
        int color = this.model.getColorManager().getColor(DAWColors.getColorIndex(track.getColor()));
        ((LaunchpadControlSurface)this.surface).setupFader(index, color);
    }
}

