/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.launchpad.controller;

import de.mossgrabers.controller.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class LaunchpadPadGrid
extends PadGridImpl {
    static final int[] TRANSLATE_MATRIX = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 21, 22, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34, 35, 36, 37, 38, 41, 42, 43, 44, 45, 46, 47, 48, 51, 52, 53, 54, 55, 56, 57, 58, 61, 62, 63, 64, 65, 66, 67, 68, 71, 72, 73, 74, 75, 76, 77, 78, 81, 82, 83, 84, 85, 86, 87, 88};
    private static final Map<Integer, Integer> INVERSE_TRANSLATE_MATRIX = new HashMap<Integer, Integer>(64);
    private final LaunchpadControlSurface surface;

    public LaunchpadPadGrid(ColorManager colorManager, LaunchpadControlSurface surface) {
        super(colorManager, surface.getOutput());
        this.surface = surface;
    }

    @Override
    protected void sendBlinkState(int note, int blinkColor, boolean fast) {
        this.surface.sendLaunchpadSysEx("23 " + StringUtils.toHexStr(note) + " " + StringUtils.toHexStr(blinkColor));
    }

    @Override
    public int translateToGrid(int note) {
        Integer value = INVERSE_TRANSLATE_MATRIX.get(note);
        return value == null ? -1 : value;
    }

    @Override
    public int translateToController(int note) {
        return TRANSLATE_MATRIX[note - 36];
    }

    static {
        for (int i = 0; i < TRANSLATE_MATRIX.length; ++i) {
            INVERSE_TRANSLATE_MATRIX.put(TRANSLATE_MATRIX[i], 36 + i);
        }
    }
}

